/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee.util;

import com.google.gson.reflect.TypeToken;
import com.imaginarycode.minecraft.redisbungee.RedisBungee;
import com.imaginarycode.minecraft.redisbungee.internal.okhttp.OkHttpClient;
import com.imaginarycode.minecraft.redisbungee.internal.okhttp.Request;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class NameFetcher {
    private static OkHttpClient httpClient;

    public static List<String> nameHistoryFromUuid(UUID uuid) throws IOException {
        String url = "https://api.mojang.com/user/profiles/" + uuid.toString().replace("-", "") + "/names";
        Request request = new Request.Builder().url(url).get().build();
        String response = httpClient.newCall(request).execute().body().string();
        Type listType = new TypeToken<List<Name>>(){}.getType();
        List names = (List)RedisBungee.getGson().fromJson(response, listType);
        ArrayList<String> humanNames = new ArrayList<String>();
        for (Name name : names) {
            humanNames.add(name.name);
        }
        return humanNames;
    }

    private NameFetcher() {
    }

    public static void setHttpClient(OkHttpClient httpClient) {
        NameFetcher.httpClient = httpClient;
    }

    public static class Name {
        private String name;
        private long changedToAt;
    }
}

