/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee.internal.jedis;

import com.imaginarycode.minecraft.redisbungee.internal.jedis.Builder;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Response;
import java.util.LinkedList;
import java.util.Queue;

public class Queable {
    private Queue<Response<?>> pipelinedResponses = new LinkedList();

    protected void clean() {
        this.pipelinedResponses.clear();
    }

    protected Response<?> generateResponse(Object data) {
        Response<?> response = this.pipelinedResponses.poll();
        if (response != null) {
            response.set(data);
        }
        return response;
    }

    protected <T> Response<T> getResponse(Builder<T> builder) {
        Response<T> lr = new Response<T>(builder);
        this.pipelinedResponses.add(lr);
        return lr;
    }

    protected boolean hasPipelinedResponse() {
        return this.pipelinedResponses.size() > 0;
    }

    protected int getPipelinedResponseLength() {
        return this.pipelinedResponses.size();
    }
}

