/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee;

import com.google.common.annotations.VisibleForTesting;
import com.imaginarycode.minecraft.redisbungee.RedisBungee;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Jedis;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Pipeline;

@VisibleForTesting
public class RedisUtil {
    public static void cleanUpPlayer(String player, Jedis rsc) {
        rsc.srem("proxy:" + RedisBungee.getApi().getServerId() + ":usersOnline", player);
        rsc.hdel("player:" + player, "server");
        rsc.hdel("player:" + player, "ip");
        rsc.hdel("player:" + player, "proxy");
    }

    public static void cleanUpPlayer(String player, Pipeline rsc) {
        rsc.srem("proxy:" + RedisBungee.getApi().getServerId() + ":usersOnline", player);
        rsc.hdel("player:" + player, "server");
        rsc.hdel("player:" + player, "ip");
        rsc.hdel("player:" + player, "proxy");
    }

    public static boolean canUseLua(String redisVersion) {
        String[] args = redisVersion.split("\\.");
        if (args.length < 2) {
            return false;
        }
        int major = Integer.parseInt(args[0]);
        int minor = Integer.parseInt(args[1]);
        return major >= 3 || major == 2 && minor >= 6;
    }

    private RedisUtil() {
    }
}

