/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.imaginarycode.minecraft.redisbungee.DataManager;
import com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI;
import com.imaginarycode.minecraft.redisbungee.RedisBungeeCommands;
import com.imaginarycode.minecraft.redisbungee.RedisBungeeConfiguration;
import com.imaginarycode.minecraft.redisbungee.RedisBungeeListener;
import com.imaginarycode.minecraft.redisbungee.RedisUtil;
import com.imaginarycode.minecraft.redisbungee.events.PubSubMessageEvent;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Jedis;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.JedisPool;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.JedisPoolConfig;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.JedisPubSub;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisConnectionException;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisException;
import com.imaginarycode.minecraft.redisbungee.internal.okhttp.Dispatcher;
import com.imaginarycode.minecraft.redisbungee.internal.okhttp.OkHttpClient;
import com.imaginarycode.minecraft.redisbungee.util.IOUtil;
import com.imaginarycode.minecraft.redisbungee.util.LuaManager;
import com.imaginarycode.minecraft.redisbungee.util.NameFetcher;
import com.imaginarycode.minecraft.redisbungee.util.UUIDFetcher;
import com.imaginarycode.minecraft.redisbungee.util.UUIDTranslator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import lombok.NonNull;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public final class RedisBungee
extends Plugin {
    private static Gson gson = new Gson();
    private static RedisBungeeAPI api;
    private static PubSubListener psl;
    private JedisPool pool;
    private UUIDTranslator uuidTranslator;
    private static RedisBungeeConfiguration configuration;
    private DataManager dataManager;
    private static OkHttpClient httpClient;
    private List<String> serverIds;
    private final AtomicInteger nagAboutServers = new AtomicInteger();
    private ScheduledTask integrityCheck;
    private ScheduledTask heartbeatTask;
    private boolean usingLua;
    private LuaManager.Script serverToPlayersScript;

    public static RedisBungeeAPI getApi() {
        return api;
    }

    static PubSubListener getPubSubListener() {
        return psl;
    }

    final List<String> getServerIds() {
        return this.serverIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getCurrentServerIds() {
        try (Jedis jedis = this.pool.getResource();){
            int nag = this.nagAboutServers.decrementAndGet();
            if (nag <= 0) {
                this.nagAboutServers.set(10);
            }
            ImmutableList.Builder servers = ImmutableList.builder();
            Map<String, String> heartbeats = jedis.hgetAll("heartbeats");
            for (Map.Entry<String, String> entry : heartbeats.entrySet()) {
                try {
                    long stamp = Long.parseLong(entry.getValue());
                    if (System.currentTimeMillis() < stamp + 30000L) {
                        servers.add((Object)entry.getKey());
                        continue;
                    }
                    if (nag > 0) continue;
                    this.getLogger().severe(entry.getKey() + " is " + (System.currentTimeMillis() - stamp) + "ms behind! (Time not synchronized or server down?)");
                }
                catch (NumberFormatException ignored) {}
            }
            ImmutableList immutableList = servers.build();
            return immutableList;
        }
        catch (JedisConnectionException e) {
            this.getLogger().log(Level.SEVERE, "Unable to fetch all server IDs", e);
            return Collections.singletonList(configuration.getServerId());
        }
    }

    public Set<UUID> getPlayersOnProxy(String server) {
        Preconditions.checkArgument((boolean)this.getServerIds().contains(server), (Object)(server + " is not a valid proxy ID"));
        try (Jedis jedis = this.pool.getResource();){
            Set<String> users = jedis.smembers("proxy:" + server + ":usersOnline");
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (String user : users) {
                builder.add((Object)UUID.fromString(user));
            }
            ImmutableSet immutableSet = builder.build();
            return immutableSet;
        }
    }

    final Multimap<String, UUID> serversToPlayers() {
        if (this.usingLua) {
            Collection data = (Collection)this.serverToPlayersScript.eval((List<String>)ImmutableList.of(), this.getServerIds());
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            String key = null;
            for (String s : data) {
                if (key == null) {
                    key = s;
                    continue;
                }
                builder.put((Object)key, (Object)UUID.fromString(s));
                key = null;
            }
            return builder.build();
        }
        ImmutableMultimap.Builder multimapBuilder = ImmutableMultimap.builder();
        for (UUID p : this.getPlayers()) {
            String name = this.dataManager.getServer(p);
            if (name == null) continue;
            multimapBuilder.put((Object)name, (Object)p);
        }
        return multimapBuilder.build();
    }

    final int getCount() {
        int c = 0;
        if (this.pool != null) {
            try (Jedis rsc = this.pool.getResource();){
                for (String i : this.getServerIds()) {
                    c = (int)((long)c + rsc.scard("proxy:" + i + ":usersOnline"));
                }
            }
            catch (JedisConnectionException e) {
                this.getLogger().log(Level.SEVERE, "Unable to get connection from pool - did your Redis server go away?", e);
                throw new RuntimeException("Unable to get total player count", e);
            }
        }
        return c;
    }

    private Set<String> getLocalPlayersAsUuidStrings() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ProxiedPlayer player : this.getProxy().getPlayers()) {
            builder.add((Object)player.getUniqueId().toString());
        }
        return builder.build();
    }

    final Set<UUID> getPlayers() {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        if (this.pool != null) {
            try (Jedis rsc = this.pool.getResource();){
                Set<String> users;
                ArrayList<String> keys = new ArrayList<String>();
                for (String i : this.getServerIds()) {
                    keys.add("proxy:" + i + ":usersOnline");
                }
                if (!keys.isEmpty() && (users = rsc.sunion(keys.toArray(new String[keys.size()]))) != null && !users.isEmpty()) {
                    for (String user : users) {
                        try {
                            setBuilder = setBuilder.add((Object)UUID.fromString(user));
                        }
                        catch (IllegalArgumentException ignored) {}
                    }
                }
            }
            catch (JedisConnectionException e) {
                this.getLogger().log(Level.SEVERE, "Unable to get connection from pool - did your Redis server go away?", e);
                throw new RuntimeException("Unable to get all players online", e);
            }
        }
        return setBuilder.build();
    }

    final Set<UUID> getPlayersOnServer(@NonNull String server) {
        if (server == null) {
            throw new NullPointerException("server");
        }
        Preconditions.checkArgument((boolean)this.getProxy().getServers().containsKey(server), (Object)"server does not exist");
        return ImmutableSet.copyOf((Collection)this.serversToPlayers().get((Object)server));
    }

    final void sendProxyCommand(@NonNull String proxyId, @NonNull String command) {
        if (proxyId == null) {
            throw new NullPointerException("proxyId");
        }
        if (command == null) {
            throw new NullPointerException("command");
        }
        Preconditions.checkArgument((this.getServerIds().contains(proxyId) || proxyId.equals("allservers") ? 1 : 0) != 0, (Object)"proxyId is invalid");
        this.sendChannelMessage("redisbungee-" + proxyId, command);
    }

    final void sendChannelMessage(String channel, String message) {
        try (Jedis jedis = this.pool.getResource();){
            jedis.publish(channel, message);
        }
        catch (JedisConnectionException e) {
            this.getLogger().log(Level.SEVERE, "Unable to get connection from pool - did your Redis server go away?", e);
            throw new RuntimeException("Unable to publish channel message", e);
        }
    }

    public void onEnable() {
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load/save config", e);
        }
        catch (JedisConnectionException e) {
            throw new RuntimeException("Unable to connect to your Redis server!", e);
        }
        if (this.pool != null) {
            try (Jedis tmpRsc = this.pool.getResource();){
                long uuidCacheSize;
                tmpRsc.hset("heartbeats", configuration.getServerId(), String.valueOf(System.currentTimeMillis()));
                String info = tmpRsc.info();
                for (String s : info.split("\r\n")) {
                    if (!s.startsWith("redis_version:")) continue;
                    String version = s.split(":")[1];
                    this.usingLua = RedisUtil.canUseLua(version);
                    if (!this.usingLua) {
                        this.getLogger().warning("Your version of Redis (" + version + ") is below 2.6. RedisBungee will disable optimizations using Lua.");
                        this.getLogger().warning("Support for versions of Redis below version 2.6 will be removed in the future.");
                        break;
                    }
                    this.getLogger().info("Using Redis >= 2.6, enabling Lua optimizations.");
                    LuaManager manager = new LuaManager(this);
                    this.serverToPlayersScript = manager.createScript(IOUtil.readInputStreamAsString(this.getResourceAsStream("lua/server_to_players.lua")));
                    break;
                }
                if ((uuidCacheSize = tmpRsc.hlen("uuid-cache").longValue()) > 750000L) {
                    this.getLogger().info("Looks like you have a really big UUID cache! Run https://www.spigotmc.org/resources/redisbungeecleaner.8505/ as soon as possible.");
                }
            }
            this.serverIds = this.getCurrentServerIds();
            this.uuidTranslator = new UUIDTranslator(this);
            this.heartbeatTask = this.getProxy().getScheduler().schedule((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    try (Jedis rsc = RedisBungee.this.pool.getResource();){
                        rsc.hset("heartbeats", configuration.getServerId(), String.valueOf(System.currentTimeMillis()));
                    }
                    catch (JedisConnectionException e) {
                        RedisBungee.this.getLogger().log(Level.SEVERE, "Unable to update heartbeat - did your Redis server go away?", e);
                    }
                    RedisBungee.this.serverIds = RedisBungee.this.getCurrentServerIds();
                }
            }, 0L, 3L, TimeUnit.SECONDS);
            this.dataManager = new DataManager(this);
            if (configuration.isRegisterBungeeCommands()) {
                this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new RedisBungeeCommands.GlistCommand(this));
                this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new RedisBungeeCommands.FindCommand(this));
                this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new RedisBungeeCommands.LastSeenCommand(this));
                this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new RedisBungeeCommands.IpCommand(this));
            }
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new RedisBungeeCommands.SendToAll(this));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new RedisBungeeCommands.ServerId(this));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new RedisBungeeCommands.ServerIds());
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new RedisBungeeCommands.PlayerProxyCommand(this));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new RedisBungeeCommands.PlistCommand(this));
            api = new RedisBungeeAPI(this);
            this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new RedisBungeeListener(this, configuration.getExemptAddresses()));
            this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this.dataManager);
            psl = new PubSubListener();
            this.getProxy().getScheduler().runAsync((Plugin)this, (Runnable)psl);
            this.integrityCheck = this.getProxy().getScheduler().schedule((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    try (Jedis tmpRsc = RedisBungee.this.pool.getResource();){
                        Set players = RedisBungee.this.getLocalPlayersAsUuidStrings();
                        Set<String> redisCollection = tmpRsc.smembers("proxy:" + configuration.getServerId() + ":usersOnline");
                        for (String member : redisCollection) {
                            if (players.contains(member)) continue;
                            boolean found = false;
                            for (String proxyId : RedisBungee.this.getServerIds()) {
                                if (proxyId.equals(configuration.getServerId()) || !tmpRsc.sismember("proxy:" + proxyId + ":usersOnline", member).booleanValue()) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                RedisUtil.cleanUpPlayer(member, tmpRsc);
                                RedisBungee.this.getLogger().warning("Player found in set that was not found locally and globally: " + member);
                                continue;
                            }
                            tmpRsc.srem("proxy:" + configuration.getServerId() + ":usersOnline", member);
                            RedisBungee.this.getLogger().warning("Player found in set that was not found locally, but is on another proxy: " + member);
                        }
                        for (String player : players) {
                            if (redisCollection.contains(player)) continue;
                            RedisBungee.this.getLogger().warning("Player " + player + " is on the proxy but not in Redis.");
                            tmpRsc.sadd("proxy:" + configuration.getServerId() + ":usersOnline", player);
                        }
                    }
                }
            }, 0L, 1L, TimeUnit.MINUTES);
        }
        this.getProxy().registerChannel("RedisBungee");
    }

    public void onDisable() {
        if (this.pool != null) {
            psl.poison();
            this.getProxy().getScheduler().cancel((Plugin)this);
            this.integrityCheck.cancel();
            this.heartbeatTask.cancel();
            this.getProxy().getPluginManager().unregisterListeners((Plugin)this);
            try (Jedis tmpRsc = this.pool.getResource();){
                tmpRsc.hdel("heartbeats", configuration.getServerId());
                if (tmpRsc.scard("proxy:" + configuration.getServerId() + ":usersOnline") > 0L) {
                    Set<String> players = tmpRsc.smembers("proxy:" + configuration.getServerId() + ":usersOnline");
                    for (String member : players) {
                        RedisUtil.cleanUpPlayer(member, tmpRsc);
                    }
                }
            }
            this.pool.destroy();
        }
    }

    private void loadConfig() throws IOException, JedisConnectionException {
        block54: {
            File file;
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdir();
            }
            if (!(file = new File(this.getDataFolder(), "config.yml")).exists()) {
                file.createNewFile();
                try (InputStream in = this.getResourceAsStream("example_config.yml");
                     FileOutputStream out = new FileOutputStream(file);){
                    ByteStreams.copy((InputStream)in, (OutputStream)out);
                }
            }
            final Configuration configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(file);
            final String redisServer = configuration.getString("redis-server", "localhost");
            final int redisPort = configuration.getInt("redis-port", 6379);
            String redisPassword = configuration.getString("redis-password");
            String serverId = configuration.getString("server-id");
            if (redisPassword != null && (redisPassword.isEmpty() || redisPassword.equals("none"))) {
                redisPassword = null;
            }
            if (serverId == null || serverId.isEmpty()) {
                throw new RuntimeException("server-id is not specified in the configuration or is empty");
            }
            if (redisServer != null && !redisServer.isEmpty()) {
                final String finalRedisPassword = redisPassword;
                FutureTask<JedisPool> task = new FutureTask<JedisPool>(new Callable<JedisPool>(){

                    @Override
                    public JedisPool call() throws Exception {
                        ClassLoader previous = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(RedisBungee.class.getClassLoader());
                        JedisPoolConfig config = new JedisPoolConfig();
                        config.setMaxTotal(configuration.getInt("max-redis-connections", 8));
                        config.setJmxEnabled(false);
                        JedisPool pool = new JedisPool(config, redisServer, redisPort, 0, finalRedisPassword);
                        Thread.currentThread().setContextClassLoader(previous);
                        return pool;
                    }
                });
                this.getProxy().getScheduler().runAsync((Plugin)this, task);
                try {
                    this.pool = task.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException("Unable to create Redis pool", e);
                }
                try (Jedis rsc = this.pool.getResource();){
                    rsc.ping();
                    File crashFile = new File(this.getDataFolder(), "restarted_from_crash.txt");
                    if (crashFile.exists()) {
                        crashFile.delete();
                    } else if (rsc.hexists("heartbeats", serverId).booleanValue()) {
                        try {
                            long value = Long.parseLong(rsc.hget("heartbeats", serverId));
                            if (System.currentTimeMillis() < value + 20000L) {
                                this.getLogger().severe("You have launched a possible impostor BungeeCord instance. Another instance is already running.");
                                this.getLogger().severe("For data consistency reasons, RedisBungee will now disable itself.");
                                this.getLogger().severe("If this instance is coming up from a crash, create a file in your RedisBungee plugins directory with the name 'restarted_from_crash.txt' and RedisBungee will not perform this check.");
                                throw new RuntimeException("Possible impostor instance!");
                            }
                        }
                        catch (NumberFormatException ignored) {
                            // empty catch block
                        }
                    }
                    FutureTask<Void> task2 = new FutureTask<Void>(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            httpClient = new OkHttpClient();
                            Dispatcher dispatcher = new Dispatcher(RedisBungee.this.getExecutorService());
                            httpClient.setDispatcher(dispatcher);
                            NameFetcher.setHttpClient(httpClient);
                            UUIDFetcher.setHttpClient(httpClient);
                            configuration = new RedisBungeeConfiguration(RedisBungee.this.getPool(), configuration);
                            return null;
                        }
                    });
                    this.getProxy().getScheduler().runAsync((Plugin)this, task2);
                    try {
                        task2.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException("Unable to create HTTP client", e);
                    }
                    this.getLogger().log(Level.INFO, "Successfully connected to Redis.");
                    break block54;
                }
                catch (JedisConnectionException e) {
                    this.pool.destroy();
                    this.pool = null;
                    throw e;
                }
            }
            throw new RuntimeException("No redis server specified!");
        }
    }

    public static Gson getGson() {
        return gson;
    }

    static PubSubListener getPsl() {
        return psl;
    }

    public JedisPool getPool() {
        return this.pool;
    }

    public UUIDTranslator getUuidTranslator() {
        return this.uuidTranslator;
    }

    static RedisBungeeConfiguration getConfiguration() {
        return configuration;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public static OkHttpClient getHttpClient() {
        return httpClient;
    }

    static {
        psl = null;
    }

    private class JedisPubSubHandler
    extends JedisPubSub {
        private JedisPubSubHandler() {
        }

        @Override
        public void onMessage(final String s, final String s2) {
            if (s2.trim().length() == 0) {
                return;
            }
            RedisBungee.this.getProxy().getScheduler().runAsync((Plugin)RedisBungee.this, new Runnable(){

                @Override
                public void run() {
                    RedisBungee.this.getProxy().getPluginManager().callEvent((Event)new PubSubMessageEvent(s, s2));
                }
            });
        }
    }

    class PubSubListener
    implements Runnable {
        private JedisPubSubHandler jpsh;

        @Override
        public void run() {
            try (Jedis rsc = RedisBungee.this.pool.getResource();){
                this.jpsh = new JedisPubSubHandler();
                rsc.subscribe(this.jpsh, "redisbungee-" + configuration.getServerId(), "redisbungee-allservers", "redisbungee-data");
            }
            catch (JedisException | ClassCastException runtimeException) {
                // empty catch block
            }
        }

        public void addChannel(String ... channel) {
            this.jpsh.subscribe(channel);
        }

        public void removeChannel(String ... channel) {
            this.jpsh.unsubscribe(channel);
        }

        public void poison() {
            this.jpsh.unsubscribe();
        }

        private PubSubListener() {
        }
    }
}

