/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee.util;

import com.google.common.base.Charsets;
import com.google.common.collect.Iterables;
import com.imaginarycode.minecraft.redisbungee.RedisBungee;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Jedis;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisException;
import com.imaginarycode.minecraft.redisbungee.util.NameFetcher;
import com.imaginarycode.minecraft.redisbungee.util.UUIDFetcher;
import java.beans.ConstructorProperties;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.regex.Pattern;
import lombok.NonNull;
import net.md_5.bungee.api.ProxyServer;

public final class UUIDTranslator {
    private static final Pattern UUID_PATTERN = Pattern.compile("[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}");
    private static final Pattern MOJANGIAN_UUID_PATTERN = Pattern.compile("[a-fA-F0-9]{32}");
    private final RedisBungee plugin;
    private final Map<String, CachedUUIDEntry> nameToUuidMap = new ConcurrentHashMap<String, CachedUUIDEntry>(128, 0.5f, 4);
    private final Map<UUID, CachedUUIDEntry> uuidToNameMap = new ConcurrentHashMap<UUID, CachedUUIDEntry>(128, 0.5f, 4);

    private void addToMaps(String name, UUID uuid) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 3);
        CachedUUIDEntry entry = new CachedUUIDEntry(name, uuid, calendar);
        this.nameToUuidMap.put(name.toLowerCase(), entry);
        this.uuidToNameMap.put(uuid, entry);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final UUID getTranslatedUuid(@NonNull String player, boolean expensiveLookups) {
        if (player == null) {
            throw new NullPointerException("player");
        }
        if (ProxyServer.getInstance().getPlayer(player) != null) {
            return ProxyServer.getInstance().getPlayer(player).getUniqueId();
        }
        CachedUUIDEntry cachedUUIDEntry = this.nameToUuidMap.get(player.toLowerCase());
        if (cachedUUIDEntry != null) {
            if (!cachedUUIDEntry.expired()) {
                return cachedUUIDEntry.getUuid();
            }
            this.nameToUuidMap.remove(player);
        }
        if (UUID_PATTERN.matcher(player).find()) {
            return UUID.fromString(player);
        }
        if (MOJANGIAN_UUID_PATTERN.matcher(player).find()) {
            return UUIDFetcher.getUUID(player);
        }
        if (!this.plugin.getProxy().getConfig().isOnlineMode()) {
            return UUID.nameUUIDFromBytes(("OfflinePlayer:" + player).getBytes(Charsets.UTF_8));
        }
        try (Jedis jedis = this.plugin.getPool().getResource();){
            Map.Entry entry;
            Object uuidMap1;
            CachedUUIDEntry entry2;
            String stored = jedis.hget("uuid-cache", player.toLowerCase());
            if (stored != null) {
                entry2 = (CachedUUIDEntry)RedisBungee.getGson().fromJson(stored, CachedUUIDEntry.class);
                if (!entry2.expired()) {
                    this.nameToUuidMap.put(player.toLowerCase(), entry2);
                    this.uuidToNameMap.put(entry2.getUuid(), entry2);
                    UUID uUID = entry2.getUuid();
                    return uUID;
                }
                jedis.hdel("uuid-cache", player.toLowerCase());
            }
            if (!expensiveLookups) {
                entry2 = null;
                return entry2;
            }
            try {
                uuidMap1 = new UUIDFetcher(Collections.singletonList(player)).call();
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Unable to fetch UUID from Mojang for " + player, e);
                UUID x2 = null;
                if (jedis == null) return x2;
                if (var5_6 == null) {
                    jedis.close();
                    return x2;
                }
                try {
                    jedis.close();
                    return x2;
                }
                catch (Throwable x22) {
                    var5_6.addSuppressed(x22);
                    return x2;
                }
            }
            Iterator i$ = uuidMap1.entrySet().iterator();
            do {
                if (!i$.hasNext()) return null;
            } while (!((String)(entry = i$.next()).getKey()).equalsIgnoreCase(player));
            this.persistInfo((String)entry.getKey(), (UUID)entry.getValue(), jedis);
            UUID uUID = (UUID)entry.getValue();
            return uUID;
        }
        catch (JedisException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Unable to fetch UUID for " + player, e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String getNameFromUuid(@NonNull UUID player, boolean expensiveLookups) {
        if (player == null) {
            throw new NullPointerException("player");
        }
        if (ProxyServer.getInstance().getPlayer(player) != null) {
            return ProxyServer.getInstance().getPlayer(player).getName();
        }
        CachedUUIDEntry cachedUUIDEntry = this.uuidToNameMap.get(player);
        if (cachedUUIDEntry != null) {
            if (!cachedUUIDEntry.expired()) {
                return cachedUUIDEntry.getName();
            }
            this.uuidToNameMap.remove(player);
        }
        try (Jedis jedis = this.plugin.getPool().getResource();){
            String string;
            String name;
            CachedUUIDEntry entry;
            String stored = jedis.hget("uuid-cache", player.toString());
            if (stored != null) {
                entry = (CachedUUIDEntry)RedisBungee.getGson().fromJson(stored, CachedUUIDEntry.class);
                if (!entry.expired()) {
                    this.nameToUuidMap.put(entry.getName().toLowerCase(), entry);
                    this.uuidToNameMap.put(player, entry);
                    String string2 = entry.getName();
                    return string2;
                }
                jedis.hdel("uuid-cache", player.toString());
            }
            if (!expensiveLookups) {
                entry = null;
                return entry;
            }
            try {
                List<String> nameHist = NameFetcher.nameHistoryFromUuid(player);
                name = (String)Iterables.getLast(nameHist, null);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Unable to fetch name from Mojang for " + player, e);
                String x2 = null;
                if (jedis == null) return x2;
                if (var5_6 == null) {
                    jedis.close();
                    return x2;
                }
                try {
                    jedis.close();
                    return x2;
                }
                catch (Throwable x22) {
                    var5_6.addSuppressed(x22);
                    return x2;
                }
            }
            if (name != null) {
                this.persistInfo(name, player, jedis);
                string = name;
                return string;
            }
            string = null;
            return string;
        }
        catch (JedisException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Unable to fetch name for " + player, e);
            return null;
        }
    }

    public final void persistInfo(String name, UUID uuid, Jedis jedis) {
        this.addToMaps(name, uuid);
        jedis.hset("uuid-cache", name.toLowerCase(), RedisBungee.getGson().toJson((Object)this.uuidToNameMap.get(uuid)));
        jedis.hset("uuid-cache", uuid.toString(), RedisBungee.getGson().toJson((Object)this.uuidToNameMap.get(uuid)));
    }

    @ConstructorProperties(value={"plugin"})
    public UUIDTranslator(RedisBungee plugin) {
        this.plugin = plugin;
    }

    private class CachedUUIDEntry {
        private final String name;
        private final UUID uuid;
        private final Calendar expiry;

        public boolean expired() {
            return Calendar.getInstance().after(this.expiry);
        }

        @ConstructorProperties(value={"name", "uuid", "expiry"})
        public CachedUUIDEntry(String name, UUID uuid, Calendar expiry) {
            this.name = name;
            this.uuid = uuid;
            this.expiry = expiry;
        }

        public String getName() {
            return this.name;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public Calendar getExpiry() {
            return this.expiry;
        }
    }
}

