/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee.internal.jedisutil;

import com.imaginarycode.minecraft.redisbungee.internal.commonspool2.PooledObjectFactory;
import com.imaginarycode.minecraft.redisbungee.internal.commonspool2.impl.GenericObjectPool;
import com.imaginarycode.minecraft.redisbungee.internal.commonspool2.impl.GenericObjectPoolConfig;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisConnectionException;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.exceptions.JedisException;

public abstract class Pool<T> {
    protected GenericObjectPool<T> internalPool;

    public Pool() {
    }

    public Pool(GenericObjectPoolConfig poolConfig, PooledObjectFactory<T> factory) {
        this.initPool(poolConfig, factory);
    }

    public void initPool(GenericObjectPoolConfig poolConfig, PooledObjectFactory<T> factory) {
        if (this.internalPool != null) {
            try {
                this.closeInternalPool();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.internalPool = new GenericObjectPool<T>(factory, poolConfig);
    }

    public T getResource() {
        try {
            return this.internalPool.borrowObject();
        }
        catch (Exception e) {
            throw new JedisConnectionException("Could not get a resource from the pool", e);
        }
    }

    public void returnResourceObject(T resource) {
        if (resource == null) {
            return;
        }
        try {
            this.internalPool.returnObject(resource);
        }
        catch (Exception e) {
            throw new JedisException("Could not return the resource to the pool", e);
        }
    }

    public void returnBrokenResource(T resource) {
        if (resource != null) {
            this.returnBrokenResourceObject(resource);
        }
    }

    public void returnResource(T resource) {
        if (resource != null) {
            this.returnResourceObject(resource);
        }
    }

    public void destroy() {
        this.closeInternalPool();
    }

    protected void returnBrokenResourceObject(T resource) {
        try {
            this.internalPool.invalidateObject(resource);
        }
        catch (Exception e) {
            throw new JedisException("Could not return the resource to the pool", e);
        }
    }

    protected void closeInternalPool() {
        try {
            this.internalPool.close();
        }
        catch (Exception e) {
            throw new JedisException("Could not destroy the pool", e);
        }
    }
}

