/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee.internal.commonspool2.proxy;

import com.imaginarycode.minecraft.redisbungee.internal.commonspool2.UsageTracking;
import java.lang.reflect.Method;

class BaseProxyHandler<T> {
    private T pooledObject;
    private final UsageTracking<T> usageTracking;

    BaseProxyHandler(T pooledObject, UsageTracking<T> usageTracking) {
        this.pooledObject = pooledObject;
        this.usageTracking = usageTracking;
    }

    T getPooledObject() {
        return this.pooledObject;
    }

    T disableProxy() {
        T result = this.pooledObject;
        this.pooledObject = null;
        return result;
    }

    void validateProxiedObject() {
        if (this.pooledObject == null) {
            throw new IllegalStateException("This object may no longer be used as it has been returned to the Object Pool.");
        }
    }

    Object doInvoke(Method method, Object[] args) throws Throwable {
        this.validateProxiedObject();
        T object = this.getPooledObject();
        if (this.usageTracking != null) {
            this.usageTracking.use(object);
        }
        return method.invoke(object, args);
    }
}

