/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee;

import com.google.common.base.Joiner;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.imaginarycode.minecraft.redisbungee.DataManager;
import com.imaginarycode.minecraft.redisbungee.RedisBungee;
import com.imaginarycode.minecraft.redisbungee.RedisBungeeCommandSender;
import com.imaginarycode.minecraft.redisbungee.RedisUtil;
import com.imaginarycode.minecraft.redisbungee.events.PubSubMessageEvent;
import com.imaginarycode.minecraft.redisbungee.internal.jedis.Jedis;
import com.imaginarycode.minecraft.redisbungee.util.RedisCallable;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class RedisBungeeListener
implements Listener {
    private static final BaseComponent[] ALREADY_LOGGED_IN = new ComponentBuilder("You are already logged on to this server.").color(ChatColor.RED).append("\n\nIf you were disconnected forcefully, please wait up to one minute.\nIf this does not resolve your issue, please contact staff.").color(ChatColor.GRAY).create();
    private final RedisBungee plugin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onPlayerConnect(final PostLoginEvent event) {
        Jedis rsc = this.plugin.getPool().getResource();
        try {
            for (String server : this.plugin.getServerIds()) {
                if (!rsc.sismember("proxy:" + server + ":usersOnline", event.getPlayer().getUniqueId().toString()).booleanValue()) continue;
                event.getPlayer().disconnect(ALREADY_LOGGED_IN);
                return;
            }
            this.plugin.getService().submit(new RedisCallable<Void>(this.plugin){

                @Override
                protected Void call(Jedis jedis) {
                    jedis.sadd("proxy:" + RedisBungee.getApi().getServerId() + ":usersOnline", event.getPlayer().getUniqueId().toString());
                    jedis.hset("player:" + event.getPlayer().getUniqueId().toString(), "online", "0");
                    jedis.hset("player:" + event.getPlayer().getUniqueId().toString(), "ip", event.getPlayer().getAddress().getAddress().getHostAddress());
                    RedisBungeeListener.this.plugin.getUuidTranslator().persistInfo(event.getPlayer().getName(), event.getPlayer().getUniqueId(), jedis);
                    jedis.hset("player:" + event.getPlayer().getUniqueId().toString(), "proxy", RedisBungeeListener.this.plugin.getServerId());
                    jedis.publish("redisbungee-data", RedisBungee.getGson().toJson(new DataManager.DataManagerMessage<DataManager.LoginPayload>(event.getPlayer().getUniqueId(), DataManager.DataManagerMessage.Action.JOIN, new DataManager.LoginPayload(event.getPlayer().getAddress().getAddress()))));
                    return null;
                }
            });
        }
        finally {
            this.plugin.getPool().returnResource(rsc);
        }
    }

    @EventHandler
    public void onPlayerDisconnect(final PlayerDisconnectEvent event) {
        this.plugin.getService().submit(new RedisCallable<Void>(this.plugin){

            @Override
            protected Void call(Jedis jedis) {
                long timestamp = System.currentTimeMillis();
                jedis.hset("player:" + event.getPlayer().getUniqueId().toString(), "online", String.valueOf(timestamp));
                RedisUtil.cleanUpPlayer(event.getPlayer().getUniqueId().toString(), jedis);
                jedis.publish("redisbungee-data", RedisBungee.getGson().toJson(new DataManager.DataManagerMessage<DataManager.LogoutPayload>(event.getPlayer().getUniqueId(), DataManager.DataManagerMessage.Action.LEAVE, new DataManager.LogoutPayload(timestamp))));
                return null;
            }
        });
    }

    @EventHandler
    public void onServerChange(final ServerConnectedEvent event) {
        this.plugin.getService().submit(new RedisCallable<Void>(this.plugin){

            @Override
            protected Void call(Jedis jedis) {
                jedis.hset("player:" + event.getPlayer().getUniqueId().toString(), "server", event.getServer().getInfo().getName());
                jedis.publish("redisbungee-data", RedisBungee.getGson().toJson(new DataManager.DataManagerMessage<DataManager.ServerChangePayload>(event.getPlayer().getUniqueId(), DataManager.DataManagerMessage.Action.SERVER_CHANGE, new DataManager.ServerChangePayload(event.getServer().getInfo().getName()))));
                return null;
            }
        });
    }

    @EventHandler(priority=-64)
    public void onPing(final ProxyPingEvent event) {
        event.registerIntent((Plugin)this.plugin);
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ServerPing old = event.getResponse();
                ServerPing reply = new ServerPing();
                reply.setPlayers(new ServerPing.Players(old.getPlayers().getMax(), RedisBungeeListener.this.plugin.getCount(), old.getPlayers().getSample()));
                reply.setDescription(old.getDescription());
                reply.setFavicon(old.getFaviconObject());
                reply.setVersion(old.getVersion());
                event.setResponse(reply);
                event.completeIntent((Plugin)RedisBungeeListener.this.plugin);
            }
        });
    }

    @EventHandler
    public void onPluginMessage(final PluginMessageEvent event) {
        if (event.getTag().equals("RedisBungee") && event.getSender() instanceof Server) {
            final byte[] data = Arrays.copyOf(event.getData(), event.getData().length);
            this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
                    String subchannel = in.readUTF();
                    ByteArrayDataOutput out = ByteStreams.newDataOutput();
                    switch (subchannel) {
                        case "PlayerList": {
                            out.writeUTF("PlayerList");
                            Set<Object> original = Collections.emptySet();
                            String type = in.readUTF();
                            if (type.equals("ALL")) {
                                out.writeUTF("ALL");
                                original = RedisBungeeListener.this.plugin.getPlayers();
                            } else {
                                try {
                                    original = RedisBungeeListener.this.plugin.getPlayersOnServer(type);
                                }
                                catch (IllegalArgumentException ignored) {
                                    // empty catch block
                                }
                            }
                            HashSet<String> players = new HashSet<String>();
                            for (UUID uUID : original) {
                                players.add(RedisBungeeListener.this.plugin.getUuidTranslator().getNameFromUuid(uUID, false));
                            }
                            out.writeUTF(Joiner.on((char)',').join(players));
                            break;
                        }
                        case "PlayerCount": {
                            out.writeUTF("PlayerCount");
                            String type = in.readUTF();
                            if (type.equals("ALL")) {
                                out.writeUTF("ALL");
                                out.writeInt(RedisBungeeListener.this.plugin.getCount());
                                break;
                            }
                            out.writeUTF(type);
                            try {
                                out.writeInt(RedisBungeeListener.this.plugin.getPlayersOnServer(type).size());
                            }
                            catch (IllegalArgumentException e) {
                                out.writeInt(0);
                            }
                            break;
                        }
                        case "LastOnline": {
                            String user = in.readUTF();
                            out.writeUTF("LastOnline");
                            out.writeUTF(user);
                            out.writeLong(RedisBungee.getApi().getLastOnline(RedisBungeeListener.this.plugin.getUuidTranslator().getTranslatedUuid(user, true)));
                            break;
                        }
                    }
                    ((Server)event.getSender()).sendData("RedisBungee", out.toByteArray());
                }
            });
        }
    }

    @EventHandler
    public void onPubSubMessage(PubSubMessageEvent event) {
        if (event.getChannel().equals("redisbungee-allservers") || event.getChannel().equals("redisbungee-" + RedisBungee.getApi().getServerId())) {
            String message = event.getMessage();
            if (message.startsWith("/")) {
                message = message.substring(1);
            }
            this.plugin.getLogger().info("Invoking command via PubSub: /" + message);
            this.plugin.getProxy().getPluginManager().dispatchCommand((CommandSender)RedisBungeeCommandSender.instance, message);
        }
    }

    @ConstructorProperties(value={"plugin"})
    public RedisBungeeListener(RedisBungee plugin) {
        this.plugin = plugin;
    }
}

