/*
 * Decompiled with CFR 0.152.
 */
package com.imaginarycode.minecraft.redisbungee;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.imaginarycode.minecraft.redisbungee.RedisBungee;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;

class RedisBungeeCommands {
    private static final BaseComponent[] NO_PLAYER_SPECIFIED = new ComponentBuilder("You must specify a player name.").color(ChatColor.RED).create();
    private static final BaseComponent[] PLAYER_NOT_FOUND = new ComponentBuilder("No such player found.").color(ChatColor.RED).create();
    private static final BaseComponent[] NO_COMMAND_SPECIFIED = new ComponentBuilder("You must specify a command to be run.").color(ChatColor.RED).create();

    RedisBungeeCommands() {
    }

    public static class ServerIds
    extends Command {
        public ServerIds() {
            super("serverids", "redisbungee.command.serverids", new String[0]);
        }

        public void execute(CommandSender sender, String[] strings) {
            TextComponent textComponent = new TextComponent();
            textComponent.setText("All server IDs: " + Joiner.on((String)", ").join(RedisBungee.getApi().getAllServers()));
            textComponent.setColor(ChatColor.YELLOW);
            sender.sendMessage((BaseComponent)textComponent);
        }
    }

    public static class ServerId
    extends Command {
        private final RedisBungee plugin;

        ServerId(RedisBungee plugin) {
            super("serverid", "redisbungee.command.serverid", new String[]{"rserverid"});
            this.plugin = plugin;
        }

        public void execute(CommandSender sender, String[] args) {
            TextComponent textComponent = new TextComponent();
            textComponent.setText("You are on " + RedisBungee.getApi().getServerId() + ".");
            textComponent.setColor(ChatColor.YELLOW);
            sender.sendMessage((BaseComponent)textComponent);
        }
    }

    public static class SendToAll
    extends Command {
        private final RedisBungee plugin;

        SendToAll(RedisBungee plugin) {
            super("sendtoall", "redisbungee.command.sendtoall", new String[]{"rsendtoall"});
            this.plugin = plugin;
        }

        public void execute(CommandSender sender, String[] args) {
            if (args.length > 0) {
                String command = Joiner.on((String)" ").skipNulls().join((Object[])args);
                RedisBungee.getApi().sendProxyCommand(command);
                TextComponent message = new TextComponent();
                message.setColor(ChatColor.GREEN);
                message.setText("Sent the command /" + command + " to all proxies.");
                sender.sendMessage((BaseComponent)message);
            } else {
                sender.sendMessage(NO_COMMAND_SPECIFIED);
            }
        }
    }

    public static class PlayerProxyCommand
    extends Command {
        private final RedisBungee plugin;

        PlayerProxyCommand(RedisBungee plugin) {
            super("pproxy", "redisbungee.command.pproxy", new String[0]);
            this.plugin = plugin;
        }

        public void execute(final CommandSender sender, final String[] args) {
            this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (args.length > 0) {
                        UUID uuid = PlayerProxyCommand.this.plugin.getUuidTranslator().getTranslatedUuid(args[0], true);
                        if (uuid == null) {
                            sender.sendMessage(PLAYER_NOT_FOUND);
                            return;
                        }
                        String proxy = RedisBungee.getApi().getProxy(uuid);
                        if (proxy != null) {
                            TextComponent message = new TextComponent();
                            message.setColor(ChatColor.GREEN);
                            message.setText(args[0] + " is connected to " + proxy + ".");
                            sender.sendMessage((BaseComponent)message);
                        } else {
                            sender.sendMessage(PLAYER_NOT_FOUND);
                        }
                    } else {
                        sender.sendMessage(NO_PLAYER_SPECIFIED);
                    }
                }
            });
        }
    }

    public static class IpCommand
    extends Command {
        private final RedisBungee plugin;

        IpCommand(RedisBungee plugin) {
            super("ip", "redisbungee.command.ip", new String[]{"playerip", "rip", "rplayerip"});
            this.plugin = plugin;
        }

        public void execute(final CommandSender sender, final String[] args) {
            this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (args.length > 0) {
                        UUID uuid = IpCommand.this.plugin.getUuidTranslator().getTranslatedUuid(args[0], true);
                        if (uuid == null) {
                            sender.sendMessage(PLAYER_NOT_FOUND);
                            return;
                        }
                        InetAddress ia = RedisBungee.getApi().getPlayerIp(uuid);
                        if (ia != null) {
                            TextComponent message = new TextComponent();
                            message.setColor(ChatColor.GREEN);
                            message.setText(args[0] + " is connected from " + ia.toString() + ".");
                            sender.sendMessage((BaseComponent)message);
                        } else {
                            sender.sendMessage(PLAYER_NOT_FOUND);
                        }
                    } else {
                        sender.sendMessage(NO_PLAYER_SPECIFIED);
                    }
                }
            });
        }
    }

    public static class LastSeenCommand
    extends Command {
        private final RedisBungee plugin;

        LastSeenCommand(RedisBungee plugin) {
            super("lastseen", "redisbungee.command.lastseen", new String[]{"rlastseen"});
            this.plugin = plugin;
        }

        public void execute(final CommandSender sender, final String[] args) {
            this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (args.length > 0) {
                        UUID uuid = LastSeenCommand.this.plugin.getUuidTranslator().getTranslatedUuid(args[0], true);
                        if (uuid == null) {
                            sender.sendMessage(PLAYER_NOT_FOUND);
                            return;
                        }
                        long secs = RedisBungee.getApi().getLastOnline(uuid);
                        TextComponent message = new TextComponent();
                        if (secs == 0L) {
                            message.setColor(ChatColor.GREEN);
                            message.setText(args[0] + " is currently online.");
                        } else if (secs != -1L) {
                            message.setColor(ChatColor.BLUE);
                            message.setText(args[0] + " was last online on " + new SimpleDateFormat().format(secs) + ".");
                        } else {
                            message.setColor(ChatColor.RED);
                            message.setText(args[0] + " has never been online.");
                        }
                        sender.sendMessage((BaseComponent)message);
                    } else {
                        sender.sendMessage(NO_PLAYER_SPECIFIED);
                    }
                }
            });
        }
    }

    public static class FindCommand
    extends Command {
        private final RedisBungee plugin;

        FindCommand(RedisBungee plugin) {
            super("find", "bungeecord.command.find", new String[]{"rfind"});
            this.plugin = plugin;
        }

        public void execute(final CommandSender sender, final String[] args) {
            this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (args.length > 0) {
                        UUID uuid = FindCommand.this.plugin.getUuidTranslator().getTranslatedUuid(args[0], true);
                        if (uuid == null) {
                            sender.sendMessage(PLAYER_NOT_FOUND);
                            return;
                        }
                        ServerInfo si = RedisBungee.getApi().getServerFor(uuid);
                        if (si != null) {
                            TextComponent message = new TextComponent();
                            message.setColor(ChatColor.BLUE);
                            message.setText(args[0] + " is on " + si.getName() + ".");
                            sender.sendMessage((BaseComponent)message);
                        } else {
                            sender.sendMessage(PLAYER_NOT_FOUND);
                        }
                    } else {
                        sender.sendMessage(NO_PLAYER_SPECIFIED);
                    }
                }
            });
        }
    }

    public static class GlistCommand
    extends Command {
        private final RedisBungee plugin;

        GlistCommand(RedisBungee plugin) {
            super("glist", "bungeecord.command.list", new String[]{"redisbungee", "rglist"});
            this.plugin = plugin;
        }

        public void execute(final CommandSender sender, final String[] args) {
            this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    int count = RedisBungee.getApi().getPlayerCount();
                    BaseComponent[] playersOnline = new ComponentBuilder("").color(ChatColor.YELLOW).append(String.valueOf(count)).append(" player(s) are currently online.").create();
                    if (args.length > 0 && args[0].equals("showall")) {
                        if (RedisBungee.getConfiguration().getBoolean("canonical-glist", true)) {
                            Multimap<String, UUID> serverToPlayers = RedisBungee.getApi().getServerToPlayers();
                            HashMultimap human = HashMultimap.create();
                            for (Map.Entry entry : serverToPlayers.entries()) {
                                human.put(entry.getKey(), (Object)GlistCommand.this.plugin.getUuidTranslator().getNameFromUuid((UUID)entry.getValue(), false));
                            }
                            for (String server : new TreeSet(serverToPlayers.keySet())) {
                                TextComponent serverName = new TextComponent();
                                serverName.setColor(ChatColor.GREEN);
                                serverName.setText("[" + server + "] ");
                                TextComponent serverCount = new TextComponent();
                                serverCount.setColor(ChatColor.YELLOW);
                                serverCount.setText("(" + serverToPlayers.get((Object)server).size() + "): ");
                                TextComponent serverPlayers = new TextComponent();
                                serverPlayers.setColor(ChatColor.WHITE);
                                serverPlayers.setText(Joiner.on((String)", ").join((Iterable)human.get((Object)server)));
                                sender.sendMessage(new BaseComponent[]{serverName, serverCount, serverPlayers});
                            }
                        } else {
                            sender.sendMessage(new ComponentBuilder("Players: " + Joiner.on((String)", ").join(RedisBungee.getApi().getHumanPlayersOnline())).color(ChatColor.YELLOW).create());
                        }
                        sender.sendMessage(playersOnline);
                    } else {
                        sender.sendMessage(playersOnline);
                        sender.sendMessage(new ComponentBuilder("To see all players online, use /glist showall.").color(ChatColor.YELLOW).create());
                    }
                }
            });
        }
    }
}

