/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.util.sql.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import me.huanmeng.util.sql.util.NumberUtil;

public class VersionUtil {
    public static String getMavenVersion(Class<?> clazz, String id) {
        String result;
        try (InputStream stream = clazz.getClassLoader().getResourceAsStream("META-INF/maven/" + id + "/pom.properties");){
            Properties properties = new Properties();
            properties.load(stream);
            result = properties.getProperty("version");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static boolean isLastOrIs(String version, String check) {
        int[] l = VersionUtil.getIntArrayByString(version);
        int[] c = VersionUtil.getIntArrayByString(check);
        for (int i = 0; i < l.length && i < c.length; ++i) {
            if (c[i] >= l[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isOldOrIs(String version, String check) {
        int[] l = VersionUtil.getIntArrayByString(version);
        int[] c = VersionUtil.getIntArrayByString(check);
        for (int i = 0; i < l.length && i < c.length; ++i) {
            if (c[i] <= l[i]) continue;
            return false;
        }
        return true;
    }

    public static int[] getIntArrayByString(String str) {
        String[] strings = (String[])Arrays.stream(str.split("-")).flatMap(e -> Arrays.stream(e.split("_"))).flatMap(e -> Arrays.stream(e.split("\\."))).toArray(String[]::new);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String s : strings) {
            if (NumberUtil.isInt(s)) {
                list.add(Integer.parseInt(s));
                continue;
            }
            for (char c : s.toCharArray()) {
                if (!NumberUtil.isInt(String.valueOf(c))) continue;
                list.add(Integer.parseInt(String.valueOf(c)));
            }
        }
        return list.stream().mapToInt(Integer::intValue).toArray();
    }
}

