/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.util.sql.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.huanmeng.util.sql.type.HutoolAdapter;
import me.huanmeng.util.sql.util.ArrayUtil;
import me.huanmeng.util.sql.util.ClassUtil;
import me.huanmeng.util.sql.util.MethodHandleUtil;
import me.huanmeng.util.sql.util.ModifierUtil;
import me.huanmeng.util.sql.util.StrUtil;

public class ReflectUtil {
    private static final Map<Class<?>, Constructor<?>[]> CONSTRUCTORS_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Field[]> FIELDS_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Method[]> METHODS_CACHE = new ConcurrentHashMap();

    private ReflectUtil() {
    }

    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        HashSet<String> methodSet = new HashSet<String>();
        Method[] methodArray = ReflectUtil.getPublicMethods(clazz);
        if (ArrayUtil.isNotEmpty(methodArray)) {
            for (Method method : methodArray) {
                methodSet.add(method.getName());
            }
        }
        return methodSet;
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        return null == clazz ? null : clazz.getMethods();
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Method getMethodIgnoreCase(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtil.getMethod(clazz, true, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtil.getMethod(clazz, false, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (null == clazz || methodName == null || methodName.trim().isEmpty()) {
            return null;
        }
        Method[] methods = ReflectUtil.getMethods(clazz);
        if (ArrayUtil.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!StrUtil.equals(methodName, method.getName(), ignoreCase) || !ClassUtil.isAllAssignableFrom(method.getParameterTypes(), paramTypes) || method.isBridge()) continue;
                return method;
            }
        }
        return null;
    }

    public static Method getMethodByName(Class<?> clazz, String methodName) throws SecurityException {
        return ReflectUtil.getMethodByName(clazz, false, methodName);
    }

    public static Method getMethodByNameIgnoreCase(Class<?> clazz, String methodName) throws SecurityException {
        return ReflectUtil.getMethodByName(clazz, true, methodName);
    }

    public static Method getMethodByName(Class<?> clazz, boolean ignoreCase, String methodName) throws SecurityException {
        if (null == clazz || StrUtil.isBlank(methodName)) {
            return null;
        }
        Method[] methods = ReflectUtil.getMethods(clazz);
        if (ArrayUtil.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!StrUtil.equals(methodName, method.getName(), ignoreCase) || method.isBridge()) continue;
                return method;
            }
        }
        return null;
    }

    public static Set<String> getMethodNames(Class<?> clazz) throws SecurityException {
        Method[] methods;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methods = ReflectUtil.getMethods(clazz)) {
            methodSet.add(method.getName());
        }
        return methodSet;
    }

    public static Method[] getMethods(Class<?> beanClass) throws SecurityException {
        if (beanClass == null) {
            throw new NullPointerException("beanClass");
        }
        return METHODS_CACHE.computeIfAbsent(beanClass, e -> ReflectUtil.getMethodsDirectly(beanClass, true, true));
    }

    public static Method[] getMethodsDirectly(Class<?> beanClass, boolean withSupers, boolean withMethodFromObject) throws SecurityException {
        if (beanClass == null) {
            throw new NullPointerException("beanClass");
        }
        if (beanClass.isInterface()) {
            return withSupers ? beanClass.getMethods() : beanClass.getDeclaredMethods();
        }
        HashSet<Method> result = new HashSet<Method>();
        Class<?> searchType = beanClass;
        while (searchType != null && (withMethodFromObject || Object.class != searchType)) {
            result.addAll(Arrays.asList(searchType.getDeclaredMethods()));
            result.addAll(ReflectUtil.getDefaultMethodsFromInterface(searchType));
            searchType = withSupers && !searchType.isInterface() ? searchType.getSuperclass() : null;
        }
        return result.toArray(new Method[0]);
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || 1 != method.getParameterCount() || !"equals".equals(method.getName())) {
            return false;
        }
        return method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && "hashCode".equals(method.getName()) && ReflectUtil.isEmptyParam(method);
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && "toString".equals(method.getName()) && ReflectUtil.isEmptyParam(method);
    }

    public static boolean isEmptyParam(Method method) {
        return method.getParameterCount() == 0;
    }

    public static boolean isGetterOrSetterIgnoreCase(Method method) {
        return ReflectUtil.isGetterOrSetter(method, true);
    }

    public static boolean isGetterOrSetter(Method method, boolean ignoreCase) {
        if (null == method) {
            return false;
        }
        int parameterCount = method.getParameterCount();
        if (parameterCount > 1) {
            return false;
        }
        String name = method.getName();
        if ("getClass".equals(name)) {
            return false;
        }
        if (ignoreCase) {
            name = name.toLowerCase();
        }
        switch (parameterCount) {
            case 0: {
                return name.startsWith("get") || name.startsWith("is");
            }
            case 1: {
                return name.startsWith("set");
            }
        }
        return false;
    }

    public static <T> T newInstance(String clazz) {
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Instance class [%s] error!", clazz), e);
        }
    }

    private static List<Method> getDefaultMethodsFromInterface(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method m : ifc.getMethods()) {
                if (ModifierUtil.isAbstract(m)) continue;
                result.add(m);
            }
        }
        return result;
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) {
        try {
            return ReflectUtil.invokeRaw(obj, method, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T invokeRaw(Object obj, Method method, Object ... args) throws InvocationTargetException, IllegalAccessException {
        method.setAccessible(true);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] actualArgs = new Object[parameterTypes.length];
        if (null != args) {
            for (int i = 0; i < actualArgs.length; ++i) {
                if (i >= args.length || null == args[i]) {
                    actualArgs[i] = ClassUtil.getDefaultValue(parameterTypes[i]);
                    continue;
                }
                if (!parameterTypes[i].isAssignableFrom(args[i].getClass()) && HutoolAdapter.supportHutool()) {
                    Object targetValue = HutoolAdapter.convert(parameterTypes[i], args[i]);
                    if (null == targetValue) continue;
                    actualArgs[i] = targetValue;
                    continue;
                }
                actualArgs[i] = args[i];
            }
        }
        if (method.isDefault()) {
            return MethodHandleUtil.invokeSpecial(obj, method, args);
        }
        return (T)method.invoke(ClassUtil.isStatic(method) ? null : obj, actualArgs);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) {
        if (ArrayUtil.isEmpty(params)) {
            Constructor<T> constructor = ReflectUtil.getConstructor(clazz, new Class[0]);
            if (null == constructor) {
                throw new RuntimeException(String.format("No constructor for [%s]", clazz));
            }
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Instance class [%s] error!", clazz), e);
            }
        }
        Class<?>[] paramTypes = ClassUtil.getClasses(params);
        Constructor<T> constructor = ReflectUtil.getConstructor(clazz, paramTypes);
        if (null == constructor) {
            throw new RuntimeException(String.format("No Constructor matched for parameter types: [%s]", new Object[]{paramTypes}));
        }
        try {
            return constructor.newInstance(params);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Instance class [%s] error!", clazz), e);
        }
    }

    public static <T> T newInstanceIfPossible(Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (type.isPrimitive()) {
            return (T)ClassUtil.getPrimitiveDefaultValue(type);
        }
        if (type.isAssignableFrom(AbstractMap.class)) {
            type = HashMap.class;
        } else if (type.isAssignableFrom(List.class)) {
            type = ArrayList.class;
        } else if (type.isAssignableFrom(Set.class)) {
            type = HashSet.class;
        }
        try {
            return (T)ReflectUtil.newInstance(type, new Object[0]);
        }
        catch (Exception exception) {
            Constructor<Object>[] constructors;
            if (type.isEnum()) {
                return (T)type.getEnumConstants()[0];
            }
            if (type.isArray()) {
                return (T)Array.newInstance(type.getComponentType(), 0);
            }
            for (Constructor<Object> constructor : constructors = ReflectUtil.getConstructors(type)) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (0 == parameterTypes.length) continue;
                constructor.setAccessible(true);
                try {
                    return (T)constructor.newInstance(ClassUtil.getDefaultValues(parameterTypes));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static <T> Constructor<T>[] getConstructors(Class<T> beanClass) throws SecurityException {
        if (beanClass == null) {
            throw new NullPointerException("beanClass");
        }
        return CONSTRUCTORS_CACHE.computeIfAbsent(beanClass, e -> ReflectUtil.getConstructorsDirectly(beanClass));
    }

    public static Constructor<?>[] getConstructorsDirectly(Class<?> beanClass) throws SecurityException {
        return beanClass.getDeclaredConstructors();
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<T>[] constructors;
        if (null == clazz) {
            return null;
        }
        for (Constructor<T> constructor : constructors = ReflectUtil.getConstructors(clazz)) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!ClassUtil.isAllAssignableFrom(pts, parameterTypes)) continue;
            constructor.setAccessible(true);
            return constructor;
        }
        return null;
    }
}

