/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.util.sql.util;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LookupFactory {
    private static final int ALLOWED_MODES = 15;
    private static Constructor<MethodHandles.Lookup> java8LookupConstructor;
    private static Method privateLookupInMethod;

    public static MethodHandles.Lookup lookup(Class<?> callerClass) throws InvocationTargetException, IllegalAccessException {
        if (privateLookupInMethod != null) {
            return (MethodHandles.Lookup)privateLookupInMethod.invoke(MethodHandles.class, callerClass, MethodHandles.lookup());
        }
        try {
            return java8LookupConstructor.newInstance(callerClass, 15);
        }
        catch (Exception e) {
            throw new IllegalStateException("no 'Lookup(Class, int)' method in java.lang.invoke.MethodHandles.", e);
        }
    }

    static {
        try {
            privateLookupInMethod = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (privateLookupInMethod == null) {
            try {
                java8LookupConstructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                java8LookupConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("There is neither 'privateLookupIn(Class, Lookup)' nor 'Lookup(Class, int)' method in java.lang.invoke.MethodHandles.", e);
            }
        }
    }
}

