/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.util.sql.type;

import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import me.huanmeng.util.sql.api.SQLTypeParser;
import me.huanmeng.util.sql.impl.SQLEntityFieldMetaData;
import me.huanmeng.util.sql.type.HutoolAdapter;
import me.huanmeng.util.sql.type.SQLType;
import me.huanmeng.util.sql.util.BasicType;
import me.huanmeng.util.sql.util.ClassUtil;
import me.huanmeng.util.sql.util.IoUtil;

public class SQLTypes {
    protected static final Logger log = Logger.getLogger("SQLTypes");
    private final Map<Class<?>, SQLType<?>> types = new ConcurrentHashMap();

    public SQLTypes() {
        this.init();
    }

    protected void init() {
        this.registerSQLTypeWithParser(String.class, new SQLType("VARCHAR", 255), SQLTypeParser.of(ResultSet::getString));
        this.registerSQLTypeWithParser(Long.TYPE, new SQLType("BIGINT", 20), SQLTypeParser.of(ResultSet::getLong));
        this.registerSQLTypeWithParser(Integer.TYPE, new SQLType("BIGINT", 20), SQLTypeParser.of(ResultSet::getInt));
        this.registerSQLTypeWithParser(Double.TYPE, new SQLType("DOUBLE"), SQLTypeParser.of(ResultSet::getDouble));
        this.registerSQLTypeWithParser(UUID.class, new SQLType("VARCHAR", 36), SQLTypeParser.of((resultSet, s) -> UUID.fromString(resultSet.getString((String)s))));
        this.registerSQLTypeWithParser(Boolean.TYPE, new SQLType("BOOLEAN"), SQLTypeParser.of(ResultSet::getBoolean));
        this.registerSQLTypeWithParser(Timestamp.class, new SQLType("DATETIME"), SQLTypeParser.of(ResultSet::getTimestamp));
        this.registerSQLTypeWithParser(byte[].class, new SQLType("BLOB"), SQLTypeParser.of((resultSet, s) -> {
            InputStream binaryStream = resultSet.getBinaryStream((String)s);
            return IoUtil.readBytes(binaryStream);
        }));
        this.registerSQLTypeWithParser(InputStream.class, new SQLType("BLOB"), SQLTypeParser.of(ResultSet::getBinaryStream));
        this.registerSQLTypeWithParser(Enum.class, new SQLType("VARCHAR", 100), new SQLTypeParser<Enum>(){

            @Override
            public <I> Enum parser(ResultSet resultSet, String fieldName, SQLEntityFieldMetaData<I, Enum> fieldMetaData) throws SQLException {
                return Enum.valueOf(fieldMetaData.type(), resultSet.getString(fieldName));
            }
        });
        if (HutoolAdapter.supportHutool()) {
            HutoolAdapter.registerSQLType(this);
        }
    }

    public <T> void registerSQLTypeWithParser(Class<?> clazz, SQLType<T> sqlType, SQLTypeParser<T> sqlTypeParser) {
        this.registerSQLType(clazz, sqlType.typeParser(sqlTypeParser));
    }

    public void registerSQLType(Class<?> clazz, SQLType<?> type) {
        this.types.put(clazz, type);
    }

    public <T> SQLType<T> getSQLType(Class<?> clazz) {
        if (clazz.isEnum()) {
            return this.types.get(Enum.class);
        }
        return this.types.computeIfAbsent(ClassUtil.isBasicType(clazz) ? BasicType.unWrap(clazz) : clazz, e -> {
            log.warning("No SQLType registered for class " + clazz.getName());
            log.warning("Using default SQLType(VARCHAR 255) for class " + clazz.getName());
            return new SQLType("VARCHAR", 255);
        });
    }
}

