/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.util.sql.type;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import me.huanmeng.util.sql.api.SQLTypeParser;
import me.huanmeng.util.sql.impl.SQLEntityFieldMetaData;
import me.huanmeng.util.sql.type.HutoolAdapter;
import org.jetbrains.annotations.NotNull;

public class SQLType<T> {
    protected final String name;
    protected int length;
    protected SQLTypeParser<T> typeParser;

    public SQLType(String name, int length) {
        this.name = name;
        this.length = length;
    }

    public SQLType(String name) {
        this.name = name;
    }

    public String toSQLString() {
        return this.length > 0 ? this.name + "(" + this.length + ")" : this.name;
    }

    public <I> void transform(ResultSet rs, SQLEntityFieldMetaData<I, T> fieldMetaData, I instance) {
        if (this.typeParser != null) {
            try {
                fieldMetaData.setValue(instance, this.typeParser.parser(rs, fieldMetaData.fieldName(), fieldMetaData));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        fieldMetaData.setValue(instance, HutoolAdapter.getResult(rs, fieldMetaData));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SQLType)) {
            return false;
        }
        SQLType sqlType = (SQLType)o;
        return this.length == sqlType.length && Objects.equals(this.name, sqlType.name) && Objects.equals(this.typeParser, sqlType.typeParser);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.length, this.typeParser);
    }

    @NotNull
    public SQLTypeParser<T> typeParser() {
        return this.typeParser;
    }

    @NotNull
    public SQLType<T> typeParser(SQLTypeParser<T> typeParser) {
        this.typeParser = typeParser;
        return this;
    }

    public String name() {
        return this.name;
    }

    public int length() {
        return this.length;
    }
}

