/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.util.sql.impl;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import me.huanmeng.util.sql.api.SQLOrderData;
import me.huanmeng.util.sql.api.SQLibrary;
import me.huanmeng.util.sql.api.annotation.SQLEntity;
import me.huanmeng.util.sql.api.annotation.SQLField;
import me.huanmeng.util.sql.impl.SQLEntityFieldMetaData;
import me.huanmeng.util.sql.util.NamingCase;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SQLEntityMetaData<T> {
    private final SQLibrary sqlibrary;
    private final Class<T> clazz;
    private String tableName;
    private final List<SQLEntityFieldMetaData<T, Object>> fields;
    private SQLOrderData orderData;

    public SQLEntityMetaData(@NotNull SQLibrary sqlibrary, @NotNull Class<T> clazz) {
        this.sqlibrary = sqlibrary;
        this.clazz = clazz;
        this.fields = new CopyOnWriteArrayList<SQLEntityFieldMetaData<T, Object>>();
        this.init();
    }

    protected void init() {
        this.tableName = NamingCase.toCamelCase(NamingCase.toUnderlineCase(this.clazz.getSimpleName()));
        Optional.ofNullable(this.clazz.getAnnotation(SQLEntity.class)).ifPresent(e -> {
            if (!e.value().trim().isEmpty()) {
                this.tableName = e.value();
            }
        });
        for (Field field : this.clazz.getDeclaredFields()) {
            SQLEntityFieldMetaData fieldMetaData = new SQLEntityFieldMetaData(this.sqlibrary, field);
            this.fields.add(fieldMetaData);
            if (this.orderData != null || fieldMetaData.order() == SQLField.Order.NONE) continue;
            this.orderData = new SQLOrderData(fieldMetaData.fieldName(), fieldMetaData.order() == SQLField.Order.ASC);
        }
    }

    @Nullable
    public SQLEntityFieldMetaData<T, Object> getField(@NotNull String name) {
        return this.fields.stream().filter(e -> e.fieldName().equals(name)).findFirst().orElse(null);
    }

    @NotNull
    public List<SQLEntityFieldMetaData<T, Object>> fields() {
        return Collections.unmodifiableList(this.fields);
    }

    @NotNull
    public List<SQLEntityFieldMetaData<T, Object>> getAutoIncrementFields() {
        return this.fields().stream().filter(SQLEntityFieldMetaData::autoIncrement).collect(Collectors.toList());
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.5")
    @NotNull
    public String tableName() {
        return this.tableName;
    }

    @NotNull
    protected String tableName0() {
        return this.tableName;
    }

    @Nullable
    public SQLOrderData orderData() {
        return this.orderData;
    }

    public SQLibrary sqlibrary() {
        return this.sqlibrary;
    }
}

