/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.util.sql.impl;

import cc.carm.lib.easysql.api.SQLManager;
import cc.carm.lib.easysql.api.SQLQuery;
import cc.carm.lib.easysql.api.action.PreparedSQLUpdateAction;
import cc.carm.lib.easysql.api.action.query.PreparedQueryAction;
import cc.carm.lib.easysql.api.builder.ConditionalBuilder;
import cc.carm.lib.easysql.api.builder.DeleteBuilder;
import cc.carm.lib.easysql.api.builder.TableQueryBuilder;
import cc.carm.lib.easysql.api.builder.UpdateBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import me.huanmeng.util.sql.api.SQLAsyncEntityManager;
import me.huanmeng.util.sql.api.SQLEntityManager;
import me.huanmeng.util.sql.api.SQLOrderData;
import me.huanmeng.util.sql.impl.SQLAsyncEntityManagerImpl;
import me.huanmeng.util.sql.impl.SQLEntityFieldMetaData;
import me.huanmeng.util.sql.impl.SQLEntityInstance;
import me.huanmeng.util.sql.impl.SQLEntityMetaData;
import me.huanmeng.util.sql.type.NULL;
import me.huanmeng.util.sql.util.BiConsumerThrowable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SQLEntityManagerImpl<T>
implements SQLEntityManager<T> {
    protected final SQLEntityInstance<T> holder;
    protected SQLAsyncEntityManager<T> asyncEntityManager;

    public SQLEntityManagerImpl(SQLEntityInstance<T> holder) {
        this.holder = holder;
    }

    @Override
    public T select(Object ... values) {
        return this.selectFirst(values);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T selectFirst(String[] name, Object ... values) {
        TableQueryBuilder builder = (TableQueryBuilder)((TableQueryBuilder)this.holder.sqlManager().createQuery().inTable(this.holder.tableName()).setLimit(1)).addCondition(name, values);
        SQLOrderData sqlOrderData = this.holder.metaData().orderData();
        if (sqlOrderData != null) {
            builder.orderBy(sqlOrderData.name(), sqlOrderData.asc());
        }
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)builder.build()).execute();){
            ResultSet rs = query.getResultSet();
            if (!rs.next()) return null;
            T t = this.transform(rs);
            return t;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T selectFirst(@NotNull String name, @NotNull Object o) {
        return this.selectFirst(new String[]{name}, o);
    }

    @Nullable
    public T transform(@NotNull ResultSet rs) {
        return this.holder.transform(rs);
    }

    public void transformToList(@NotNull List<T> list, @NotNull ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
            list.add(this.holder.transform(resultSet));
        }
    }

    @Override
    @NotNull
    public List<T> selectAny(String[] name, Object ... values) {
        ArrayList list = new ArrayList();
        TableQueryBuilder builder = (TableQueryBuilder)this.holder.sqlManager().createQuery().inTable(this.holder.tableName()).addCondition(name, Arrays.stream(values).map(o -> o == NULL.NULL ? null : o).toArray());
        SQLOrderData sqlOrderData = this.holder.metaData().orderData();
        if (sqlOrderData != null) {
            builder.orderBy(sqlOrderData.name(), sqlOrderData.asc());
        }
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)builder.build()).execute();){
            this.transformToList(list, query.getResultSet());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    @Override
    public T selectFirst(Object ... values) {
        return this.selectFirst(false, values);
    }

    @Override
    @Nullable
    public T selectFirstByAllField(Object ... values) {
        return this.selectFirst(true, values);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T selectFirst(boolean all, Object ... values) {
        TableQueryBuilder tableQueryBuilder = (TableQueryBuilder)this.holder.sqlManager().createQuery().inTable(this.holder.tableName()).setLimit(1);
        this.fillCondition(tableQueryBuilder, this.holder.names(all), values);
        SQLOrderData orderData = this.holder.metaData().orderData();
        if (orderData != null) {
            tableQueryBuilder.orderBy(orderData.name(), orderData.asc());
        }
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)tableQueryBuilder.build()).execute();){
            if (!query.getResultSet().next()) return null;
            T t = this.transform(query.getResultSet());
            return t;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public List<T> select(int limit) {
        TableQueryBuilder tableQueryBuilder = (TableQueryBuilder)this.holder.sqlManager().createQuery().inTable(this.holder.tableName()).setLimit(limit);
        SQLOrderData orderData = this.holder.metaData().orderData();
        if (orderData != null) {
            tableQueryBuilder.orderBy(orderData.name(), orderData.asc());
        }
        ArrayList ts = new ArrayList();
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)tableQueryBuilder.build()).execute();){
            this.transformToList(ts, query.getResultSet());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return ts;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public T select(SQLOrderData orderData, Object ... values) {
        TableQueryBuilder tableQueryBuilder = this.holder.sqlManager().createQuery().inTable(this.holder.tableName());
        if (orderData != null) {
            tableQueryBuilder.orderBy(orderData.name(), orderData.asc());
        }
        this.fillCondition(tableQueryBuilder, true, true, values);
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)tableQueryBuilder.build()).execute();){
            if (!query.getResultSet().next()) return null;
            T t = this.transform(query.getResultSet());
            return t;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public T selectByField(@Nullable SQLOrderData orderData, Object ... values) {
        TableQueryBuilder tableQueryBuilder = this.holder.sqlManager().createQuery().inTable(this.holder.tableName());
        if (orderData != null) {
            tableQueryBuilder.orderBy(orderData.name(), orderData.asc());
        }
        this.fillCondition(tableQueryBuilder, this.holder.names(false), values);
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)tableQueryBuilder.build()).execute();){
            if (!query.getResultSet().next()) return null;
            T t = this.transform(query.getResultSet());
            return t;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public T selectByAllField(@Nullable SQLOrderData orderData, Object ... values) {
        TableQueryBuilder tableQueryBuilder = this.holder.sqlManager().createQuery().inTable(this.holder.tableName());
        if (orderData != null) {
            tableQueryBuilder.orderBy(orderData.name(), orderData.asc());
        }
        this.fillCondition(tableQueryBuilder, this.holder.names(true), values);
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)tableQueryBuilder.build()).execute();){
            if (!query.getResultSet().next()) return null;
            T t = this.transform(query.getResultSet());
            return t;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public List<T> select(int limit, SQLOrderData orderData) {
        SQLEntityMetaData<T> metaData = this.holder.metaData();
        TableQueryBuilder tableQueryBuilder = (TableQueryBuilder)this.holder.sqlManager().createQuery().inTable(this.holder.tableName()).setLimit(limit);
        if (orderData != null) {
            tableQueryBuilder.orderBy(orderData.name(), orderData.asc());
        } else {
            SQLOrderData sqlOrderData = metaData.orderData();
            if (sqlOrderData != null) {
                tableQueryBuilder.orderBy(sqlOrderData.name(), sqlOrderData.asc());
            }
        }
        ArrayList ts = new ArrayList();
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)tableQueryBuilder.build()).execute();){
            this.transformToList(ts, query.getResultSet());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return ts;
    }

    @Override
    @NotNull
    public List<T> selectAny(int limit, SQLOrderData orderData, Object ... values) {
        SQLEntityMetaData<T> metaData = this.holder.metaData();
        TableQueryBuilder tableQueryBuilder = (TableQueryBuilder)this.holder.sqlManager().createQuery().inTable(this.holder.tableName()).setLimit(limit);
        if (orderData != null) {
            tableQueryBuilder.orderBy(orderData.name(), orderData.asc());
        } else {
            SQLOrderData sqlOrderData = metaData.orderData();
            if (sqlOrderData != null) {
                tableQueryBuilder.orderBy(sqlOrderData.name(), sqlOrderData.asc());
            }
        }
        this.fillCondition(tableQueryBuilder, true, true, values);
        ArrayList ts = new ArrayList();
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)tableQueryBuilder.build()).execute();){
            this.transformToList(ts, query.getResultSet());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return ts;
    }

    @Override
    @NotNull
    public List<T> selectAnyByField(int limit, @Nullable SQLOrderData orderData, Object ... values) {
        SQLEntityMetaData<T> metaData = this.holder.metaData();
        TableQueryBuilder tableQueryBuilder = (TableQueryBuilder)this.holder.sqlManager().createQuery().inTable(this.holder.tableName()).setLimit(limit);
        if (orderData != null) {
            tableQueryBuilder.orderBy(orderData.name(), orderData.asc());
        } else {
            SQLOrderData sqlOrderData = metaData.orderData();
            if (sqlOrderData != null) {
                tableQueryBuilder.orderBy(sqlOrderData.name(), sqlOrderData.asc());
            }
        }
        this.fillCondition(tableQueryBuilder, this.holder.names(false), values);
        ArrayList ts = new ArrayList();
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)tableQueryBuilder.build()).execute();){
            this.transformToList(ts, query.getResultSet());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return ts;
    }

    @Override
    @NotNull
    public List<T> selectAnyByAllField(int limit, @Nullable SQLOrderData orderData, Object ... values) {
        SQLEntityMetaData<T> metaData = this.holder.metaData();
        TableQueryBuilder tableQueryBuilder = (TableQueryBuilder)this.holder.sqlManager().createQuery().inTable(this.holder.tableName()).setLimit(limit);
        if (orderData != null) {
            tableQueryBuilder.orderBy(orderData.name(), orderData.asc());
        } else {
            SQLOrderData sqlOrderData = metaData.orderData();
            if (sqlOrderData != null) {
                tableQueryBuilder.orderBy(sqlOrderData.name(), sqlOrderData.asc());
            }
        }
        this.fillCondition(tableQueryBuilder, this.holder.names(true), values);
        ArrayList ts = new ArrayList();
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)tableQueryBuilder.build()).execute();){
            this.transformToList(ts, query.getResultSet());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return ts;
    }

    @Override
    @NotNull
    public List<T> selectAll(Object ... values) {
        TableQueryBuilder tableQueryBuilder = this.holder.sqlManager().createQuery().inTable(this.holder.tableName());
        this.fillCondition(tableQueryBuilder, this.holder.names(false), values);
        SQLOrderData orderData = this.holder.metaData().orderData();
        if (orderData != null) {
            tableQueryBuilder.orderBy(orderData.name(), orderData.asc());
        }
        ArrayList ts = new ArrayList();
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)tableQueryBuilder.build()).execute();){
            this.transformToList(ts, query.getResultSet());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return ts;
    }

    @Override
    @NotNull
    public List<T> selectAllByAllField(Object ... values) {
        TableQueryBuilder tableQueryBuilder = this.holder.sqlManager().createQuery().inTable(this.holder.tableName());
        this.fillCondition(tableQueryBuilder, this.holder.names(true), values);
        SQLOrderData orderData = this.holder.metaData().orderData();
        if (orderData != null) {
            tableQueryBuilder.orderBy(orderData.name(), orderData.asc());
        }
        ArrayList ts = new ArrayList();
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)tableQueryBuilder.build()).execute();){
            this.transformToList(ts, query.getResultSet());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return ts;
    }

    @Override
    @NotNull
    public List<T> selectAll() {
        ArrayList ts = new ArrayList();
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)this.holder.sqlManager().createQuery().inTable(this.holder.tableName()).build()).execute();){
            this.transformToList(ts, query.getResultSet());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return ts;
    }

    @Override
    public void update(@NotNull T entity) {
        List<SQLEntityFieldMetaData<T, Object>> list = this.holder.metaData().getAutoIncrementFields();
        UpdateBuilder updateBuilder = (UpdateBuilder)this.holder.sqlManager().createUpdate(this.holder.tableName()).setLimit(1);
        if (list.size() == 1) {
            SQLEntityFieldMetaData<T, Object> field = list.get(0);
            updateBuilder.addCondition(field.fieldName(), field.getEntityValue(entity));
            Object sqlAction = updateBuilder.setColumnValues(this.holder.fieldNames(), this.holder.fieldValues(entity)).build();
            try {
                sqlAction.execute();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        try {
            this.fillCondition(updateBuilder, true, true, this.holder.keyValues(entity, true));
            updateBuilder.setColumnValues(this.holder.names(true), this.holder.values(entity, true)).build().execute();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public T insert(@NotNull T entity) {
        try {
            PreparedSQLUpdateAction<Integer> updateAction = this.holder.sqlManager().createInsert(this.holder.tableName()).setColumnNames(this.holder.names()).setParams(this.holder.values(entity));
            if (this.holder.isSupportReturnKey()) {
                List fields = this.holder.metaData.getAutoIncrementFields();
                Integer id = (Integer)updateAction.returnGeneratedKey(Integer.class).execute();
                return this.selectFirst(new String[]{fields.get((int)0).fieldName}, new Object[]{id});
            }
            updateAction.execute();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        if (this.holder.metaData().getAutoIncrementFields().size() != 1) {
            return entity;
        }
        return this.selectLastInsertById();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T selectLastInsertById() {
        try (SQLQuery query = (SQLQuery)this.holder.sqlManager().createQuery().withPreparedSQL("select LAST_INSERT_ID()").execute();){
            ResultSet rs = query.getResultSet();
            if (!rs.next()) return null;
            long dbId = rs.getLong(1);
            T t = this.selectFirst(new String[]{this.holder.metaData().getAutoIncrementFields().get(0).fieldName()}, new Object[]{dbId});
            return t;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public T updateOrInsert(@NotNull T entity) {
        if (this.exist(entity)) {
            this.update(entity);
            return this.select(entity);
        }
        return this.insert(entity);
    }

    @Override
    public boolean exist(@NotNull T entity) {
        boolean exist;
        TableQueryBuilder tableQueryBuilder = this.holder.sqlManager().createQuery().inTable(this.holder.tableName());
        List<SQLEntityFieldMetaData<T, Object>> list = this.holder.metaData().getAutoIncrementFields();
        List collect = this.holder.metaData().fields().stream().filter(e -> !e.autoIncrement() && e.key()).collect(Collectors.toList());
        if (list.isEmpty() && !collect.isEmpty()) {
            for (SQLEntityFieldMetaData fieldMetaData : collect) {
                Object entityValue = fieldMetaData.getEntityValue(entity);
                if (entityValue == null) continue;
                tableQueryBuilder.addCondition(fieldMetaData.fieldName, entityValue);
            }
        } else {
            this.fillCondition(tableQueryBuilder, this.holder.names(false), this.holder.values(entity));
        }
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)tableQueryBuilder.build()).execute();){
            ResultSet rs = query.getResultSet();
            exist = rs.next();
        }
        catch (SQLException e2) {
            throw new RuntimeException(e2);
        }
        return exist;
    }

    @Override
    public void delete(@NotNull T entity) {
        try {
            ((DeleteBuilder)this.holder.sqlManager().createDelete(this.holder.tableName()).addCondition(this.holder.names(false), this.holder.values(entity, false))).build().execute();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public T select(@NotNull T userData) {
        TableQueryBuilder tableQueryBuilder = (TableQueryBuilder)this.holder.sqlManager().createQuery().inTable(this.holder.tableName()).setLimit(1);
        this.fillCondition(tableQueryBuilder, this.holder.names(false), this.holder.values(userData));
        SQLOrderData orderData = this.holder.metaData().orderData();
        if (orderData != null) {
            tableQueryBuilder.orderBy(orderData.name(), orderData.asc());
        }
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)tableQueryBuilder.build()).execute();){
            if (!query.getResultSet().next()) return null;
            T t = this.transform(query.getResultSet());
            return t;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void custom(@NotNull BiConsumerThrowable<SQLManager, SQLEntityInstance<T>, SQLException> run) {
        try {
            run.accept(this.holder.sqlManager(), this.holder);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean toggleDebug() {
        boolean debugMode = !this.holder.sqlManager().isDebugMode();
        this.holder.sqlManager().setDebugMode(debugMode);
        return debugMode;
    }

    @Override
    public void setDebug(boolean debug) {
        this.holder.sqlManager().setDebugMode(debug);
    }

    @Override
    public boolean isDebug() {
        return this.holder.sqlManager().isDebugMode();
    }

    @Override
    public SQLAsyncEntityManager<T> async() {
        if (this.asyncEntityManager != null) {
            return this.asyncEntityManager;
        }
        this.asyncEntityManager = new SQLAsyncEntityManagerImpl<T>(this.holder);
        return this.asyncEntityManager;
    }

    @Override
    public void delete(Object ... values) {
        try {
            DeleteBuilder deleteBuilder = this.holder.sqlManager().createDelete(this.holder.tableName());
            this.fillCondition(deleteBuilder, this.holder.names(false), values);
            deleteBuilder.build().execute();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteByAllField(Object ... values) {
        try {
            DeleteBuilder deleteBuilder = this.holder.sqlManager().createDelete(this.holder.tableName());
            this.fillCondition(deleteBuilder, this.holder.names(true), values);
            deleteBuilder.build().execute();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exist(Object ... values) {
        boolean exist;
        TableQueryBuilder tableQueryBuilder = this.holder.sqlManager().createQuery().inTable(this.holder.tableName());
        this.fillCondition(tableQueryBuilder, false, true, values);
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)tableQueryBuilder.build()).execute();){
            exist = query.getResultSet().next();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return exist;
    }

    @Override
    public boolean existByField(Object ... values) {
        boolean exist;
        TableQueryBuilder tableQueryBuilder = this.holder.sqlManager().createQuery().inTable(this.holder.tableName());
        this.fillCondition(tableQueryBuilder, this.holder.names(false), values);
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)tableQueryBuilder.build()).execute();){
            exist = query.getResultSet().next();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return exist;
    }

    @Override
    public boolean existByAllField(Object ... values) {
        boolean exist;
        TableQueryBuilder tableQueryBuilder = this.holder.sqlManager().createQuery().inTable(this.holder.tableName());
        this.fillCondition(tableQueryBuilder, this.holder.names(true), values);
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)tableQueryBuilder.build()).execute();){
            exist = query.getResultSet().next();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return exist;
    }

    @Override
    public boolean exist(@NotNull String name, @NotNull Object o) {
        boolean exist;
        TableQueryBuilder tableQueryBuilder = this.holder.sqlManager().createQuery().inTable(this.holder.tableName());
        tableQueryBuilder.addCondition(name, o);
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)tableQueryBuilder.build()).execute();){
            exist = query.getResultSet().next();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return exist;
    }

    protected void fillCondition(@NotNull ConditionalBuilder<?, ?> conditionalBuilder, boolean all, boolean lenSync, Object ... values) {
        if (lenSync) {
            this.fillCondition(conditionalBuilder, (String[])Arrays.stream(this.holder.keyNames(all)).limit(values.length).toArray(String[]::new), values);
        } else {
            this.fillCondition(conditionalBuilder, this.holder.keyNames(all), values);
        }
    }

    protected void fillCondition(@NotNull ConditionalBuilder<?, ?> conditionalBuilder, String[] names, Object ... values) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (int i = 0; i < names.length && i < values.length; ++i) {
            Object value = values[i];
            if (value == NULL.IGNORE || value == null && this.holder.metaData.sqlibrary().nullIgnore()) continue;
            if (value == NULL.NULL) {
                value = null;
            }
            map.put(names[i], value);
        }
        conditionalBuilder.addCondition(map.keySet().toArray(new String[0]), map.values().toArray());
    }
}

