/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.util.sql.impl;

import cc.carm.lib.easysql.api.SQLManager;
import cc.carm.lib.easysql.api.builder.TableCreateBuilder;
import cc.carm.lib.easysql.api.enums.IndexType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import me.huanmeng.util.sql.api.SQLibrary;
import me.huanmeng.util.sql.impl.SQLEntityFieldMetaData;
import me.huanmeng.util.sql.impl.SQLEntityManagerImpl;
import me.huanmeng.util.sql.impl.SQLEntityMetaData;
import me.huanmeng.util.sql.util.ReflectUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SQLEntityInstance<T> {
    protected final Class<T> clazz;
    protected final SQLEntityMetaData<T> metaData;
    protected final SQLManager sqlManager;
    protected final SQLEntityManagerImpl<T> sqlEntityManager;
    protected String tableName;

    public SQLEntityInstance(SQLibrary sqlibrary, Class<T> clazz, SQLManager sqlManager) throws SQLException {
        this.clazz = clazz;
        this.metaData = new SQLEntityMetaData<T>(sqlibrary, clazz);
        this.sqlManager = sqlManager;
        this.tableName = this.metaData().tableName0();
        this.createTable();
        this.sqlEntityManager = new SQLEntityManagerImpl(this);
    }

    public void createTable() throws SQLException {
        LinkedHashSet<String> dbColumns;
        TableCreateBuilder table = this.sqlManager.createTable(this.tableName());
        ArrayList<String> keys = new ArrayList<String>();
        boolean primaryKey = false;
        for (SQLEntityFieldMetaData<T, Object> field : this.metaData.fields()) {
            if (field.key() && field.indexType() == null && !field.autoIncrement()) {
                keys.add(field.fieldName());
            }
            if (field.autoIncrement()) {
                primaryKey = true;
                table.addAutoIncrementColumn(field.fieldName(), true, true);
                continue;
            }
            table.addColumn(field.fieldName(), field.sqlType().toSQLString() + (field.notNull() ? " NOT NULL" : ""));
        }
        ArrayList alterList = new ArrayList(keys);
        ArrayList<Object> columnName = new ArrayList<Object>();
        if (keys.size() == 1 && !primaryKey) {
            Iterator<SQLEntityFieldMetaData<T, Object>> s = (String)keys.remove(0);
            columnName.add(s);
            table.setIndex((String)((Object)s), IndexType.PRIMARY_KEY);
        } else if (keys.size() >= 2) {
            for (String s : keys) {
                columnName.add(s);
                table.setIndex(s, IndexType.UNIQUE_KEY);
            }
        }
        for (SQLEntityFieldMetaData<T, Object> field : this.metaData.fields()) {
            if (field.indexType() == null || columnName.contains(field.fieldName())) continue;
            table.setIndex(field.fieldName(), field.indexType());
        }
        table.setTableSettings("ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
        table.build().execute();
        try {
            dbColumns = new LinkedHashSet<String>((Collection)this.sqlManager.fetchTableMetadata(this.tableName()).listColumns().get());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        LinkedHashMap<String, SQLEntityFieldMetaData<T, Object>> columnRemap = new LinkedHashMap<String, SQLEntityFieldMetaData<T, Object>>(dbColumns.size());
        LinkedHashSet dropColumns = new LinkedHashSet();
        for (String column : dbColumns) {
            SQLEntityFieldMetaData<T, Object> field = this.metaData.getField(column);
            if (field == null) {
                columnRemap.put(column, field);
                continue;
            }
            dbColumns.add(column);
        }
    }

    @Nullable
    public T transform(@NotNull ResultSet rs) {
        T instance = this.newInstance();
        for (SQLEntityFieldMetaData<T, Object> field : this.metaData().fields()) {
            field.deserialize(rs, instance);
        }
        return instance;
    }

    @Nullable
    public T newInstance() {
        return ReflectUtil.newInstanceIfPossible(this.clazz);
    }

    @NotNull
    public String[] keyNames() {
        return this.keyNames(false);
    }

    @NotNull
    public String[] keyNames(boolean all) {
        ArrayList<String> list = new ArrayList<String>();
        for (SQLEntityFieldMetaData<T, Object> field : this.metaData.fields()) {
            if (!field.key() || field.autoIncrement() && !all) continue;
            list.add(field.fieldName());
        }
        return list.toArray(new String[0]);
    }

    @NotNull
    public Object[] keyValues(@NotNull T entity) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (SQLEntityFieldMetaData<T, Object> field : this.metaData.fields()) {
            if (!field.key() || field.autoIncrement()) continue;
            list.add(field.getEntityValue(entity));
        }
        return list.toArray(new Object[0]);
    }

    @NotNull
    public Object[] keyValues(@NotNull T entity, boolean all) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (SQLEntityFieldMetaData<T, Object> field : this.metaData.fields()) {
            if (!field.key() || !all && field.autoIncrement()) continue;
            list.add(field.getEntityValue(entity));
        }
        return list.toArray(new Object[0]);
    }

    @NotNull
    public String[] fieldNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (SQLEntityFieldMetaData<T, Object> field : this.metaData.fields()) {
            if (field.key() || field.autoIncrement()) continue;
            list.add(field.fieldName());
        }
        return list.toArray(new String[0]);
    }

    @NotNull
    public Object[] fieldValues(@NotNull T entity) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (SQLEntityFieldMetaData<T, Object> field : this.metaData.fields()) {
            if (field.key() || field.autoIncrement()) continue;
            list.add(field.getEntityValue(entity));
        }
        return list.toArray(new Object[0]);
    }

    @NotNull
    public String[] names(boolean all) {
        ArrayList<String> list = new ArrayList<String>();
        for (SQLEntityFieldMetaData<T, Object> field : this.metaData.fields()) {
            if (field.autoIncrement() && !all) continue;
            list.add(field.fieldName());
        }
        return list.toArray(new String[0]);
    }

    @NotNull
    public String[] names() {
        return this.names(false);
    }

    @NotNull
    public Object[] values(@NotNull T entity) {
        return this.values(entity, false);
    }

    @NotNull
    public Object[] values(@NotNull T entity, boolean all) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (SQLEntityFieldMetaData<T, Object> field : this.metaData.fields()) {
            if (field.autoIncrement() && !all) continue;
            list.add(field.getEntityValue(entity));
        }
        return list.toArray(new Object[0]);
    }

    @NotNull
    public SQLManager sqlManager() {
        return this.sqlManager;
    }

    @NotNull
    public SQLEntityManagerImpl<T> sqlEntityManager() {
        return this.sqlEntityManager;
    }

    @NotNull
    public SQLEntityMetaData<T> metaData() {
        return this.metaData;
    }

    @NotNull
    public String tableName() {
        return this.tableName;
    }

    @NotNull
    public SQLEntityInstance<T> tableName(@NotNull String tableName) {
        this.tableName = tableName;
        return this;
    }

    public boolean isSupportReturnKey() {
        List<SQLEntityFieldMetaData<T, Object>> autoIncrementFields = this.metaData.getAutoIncrementFields();
        return autoIncrementFields.size() == 1;
    }
}

