/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.util.sql.impl;

import cc.carm.lib.easysql.api.enums.IndexType;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import me.huanmeng.util.sql.api.SQLTypeParser;
import me.huanmeng.util.sql.api.SQLibrary;
import me.huanmeng.util.sql.api.annotation.SQLField;
import me.huanmeng.util.sql.api.annotation.SQLIgnore;
import me.huanmeng.util.sql.api.annotation.SQLJson;
import me.huanmeng.util.sql.serialize.ValueSerialize;
import me.huanmeng.util.sql.type.HutoolAdapter;
import me.huanmeng.util.sql.type.SQLType;
import me.huanmeng.util.sql.util.ArrayUtil;
import me.huanmeng.util.sql.util.NumberUtil;
import me.huanmeng.util.sql.util.ReflectUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLEntityFieldMetaData<I, T> {
    protected static Logger logger = LoggerFactory.getLogger("SQLFieldMetaData");
    protected final SQLibrary sqlibrary;
    protected final Field field;
    protected String fieldName;
    protected String remapName;
    protected boolean key;
    protected Class<?> type;
    protected Class<?> componentType;
    protected SQLType<T> sqlType;
    protected boolean autoIncrement;
    protected SQLField.Order order = SQLField.Order.NONE;
    protected String simpleName;
    protected SQLField.Serialize serialize = SQLField.Serialize.NONE;
    protected ValueSerialize valueSerialize;
    protected IndexType indexType = IndexType.UNIQUE_KEY;
    protected boolean notNull;
    protected JsonSerializer<?> jsonSerializer;
    public static final int MAX_KEY_LENGTH;
    public static final int CHAR_BYTE;

    public SQLEntityFieldMetaData(@NotNull SQLibrary sqlibrary, @NotNull Field field) {
        this.sqlibrary = sqlibrary;
        this.field = field;
        this.init();
    }

    public IndexType indexType() {
        return this.indexType;
    }

    public SQLEntityFieldMetaData<I, T> remapName(String remapName) {
        this.remapName = remapName;
        return this;
    }

    public String remapName() {
        return this.remapName;
    }

    protected void init() {
        this.field.setAccessible(true);
        this.type = this.field.getType();
        this.componentType = this.field.getType().getComponentType();
        this.sqlType = this.sqlibrary.typeByClass(this.type());
        this.simpleName = this.type().getSimpleName();
        Optional.ofNullable(this.field.getAnnotation(SQLField.class)).map(f -> {
            this.fieldName = f.value().trim().isEmpty() ? this.field.getName() : f.value();
            this.remapName = f.remapName().trim().isEmpty() ? this.fieldName : f.remapName();
            this.order = f.orderBy();
            this.indexType = f.index().get();
            this.key = f.id();
            this.notNull = f.notNull();
            if (!f.sqlType().trim().isEmpty()) {
                String[] split = f.sqlType().split(",");
                for (int i = 0; i < split.length; ++i) {
                    split[i] = split[i].trim();
                }
                if (split.length <= 1 && !split[0].isEmpty()) {
                    this.sqlType = new SQLType(split[0]);
                } else if (!split[1].isEmpty() && NumberUtil.isInt(split[1])) {
                    this.sqlType = new SQLType(split[0], Integer.parseInt(split[1]));
                }
            }
            if (this.key && this.sqlType.length() * CHAR_BYTE >= MAX_KEY_LENGTH) {
                logger.warn("[{}-{}] Errors will occur in {} and have been corrected automatically", this.fieldName, this.simpleName, this.sqlType.toSQLString());
                SQLTypeParser<T> sqlTypeParser = this.sqlType.typeParser();
                this.sqlType = new SQLType<T>(this.sqlType.name(), Math.floorDiv(MAX_KEY_LENGTH, CHAR_BYTE)).typeParser(sqlTypeParser);
            }
            if (!Objects.equals(f.parser(), SQLTypeParser.class)) {
                this.sqlType.typeParser(ReflectUtil.newInstanceIfPossible(f.parser()));
            }
            this.autoIncrement = f.isAutoIncrement();
            this.serialize = f.serialize();
            this.valueSerialize = this.sqlibrary.getSerialize(f.serializeName());
            return f;
        }).orElseGet(() -> {
            this.fieldName = this.field.getName();
            return null;
        });
        Optional.ofNullable(this.field.getAnnotation(SQLJson.class)).map(json -> {
            try {
                this.jsonSerializer = ReflectUtil.newInstanceIfPossible(json.targetClass());
            }
            catch (Exception e) {
                logger.error("SQLJson#targetClass new instance error", e);
            }
            return json;
        });
    }

    public void setValue(@NotNull I instance, @Nullable T obj) {
        try {
            Method method = ReflectUtil.getMethod(instance.getClass(), true, "set" + this.field.getName(), this.type());
            if (method != null && method.getAnnotation(SQLIgnore.class) == null) {
                ReflectUtil.invoke(instance, method, obj);
                return;
            }
            if (HutoolAdapter.supportHutool()) {
                HutoolAdapter.setFieldValue(this.field, this.type(), instance, obj);
            } else {
                this.field.set(instance, obj);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("\u8bbe\u7f6e\u6210\u5458\u53d8\u91cf %s \u65f6\u51fa\u73b0\u4e86\u9519\u8bef,value: %s", this.simpleName + "#" + this.fieldName, obj), e);
        }
    }

    public Object getEntityValue(@NotNull I entity) {
        try {
            Object o = this.valueSerialize != null ? this.valueSerialize.serialize(this, this.field.get(entity)) : this.serialize.serialize(this, this.field.get(entity));
            if (o instanceof Collection) {
                o = o.toString();
            } else if (ArrayUtil.isArray(o)) {
                if (o instanceof byte[]) {
                    return o;
                }
                return ArrayUtil.toString(o);
            }
            return o;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("\u83b7\u53d6 %s \u7684 %s \u6210\u5458\u53d8\u91cf\u51fa\u73b0\u4e86\u9519\u8bef", entity, this.fieldName), e);
        }
    }

    public void deserialize(ResultSet resultSet, I instance) {
        try {
            this.serialize.deserialize(this, resultSet, instance);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public Field field() {
        return this.field;
    }

    @NotNull
    public String fieldName() {
        return this.fieldName;
    }

    public boolean key() {
        return this.key;
    }

    @NotNull
    public SQLType<T> sqlType() {
        return this.sqlType;
    }

    public boolean autoIncrement() {
        return this.autoIncrement;
    }

    @NotNull
    public SQLField.Order order() {
        return this.order;
    }

    @NotNull
    public Class<T> type() {
        return this.type;
    }

    @Nullable
    public Class<?> componentType() {
        return this.componentType;
    }

    @NotNull
    public SQLibrary sqlibrary() {
        return this.sqlibrary;
    }

    @Nullable
    public JsonSerializer jsonSerializer() {
        return this.jsonSerializer;
    }

    public boolean notNull() {
        return this.notNull;
    }

    static {
        try {
            MAX_KEY_LENGTH = Integer.parseInt(System.getProperty("sqlibrary.max-key-length", "767"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            CHAR_BYTE = Integer.parseInt(System.getProperty("sqlibrary.char-byte", "4"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

