/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.util.sql.api.annotation;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.sql.ResultSet;
import java.sql.SQLException;
import me.huanmeng.util.sql.api.SQLTypeParser;
import me.huanmeng.util.sql.api.SQLibrary;
import me.huanmeng.util.sql.impl.SQLEntityFieldMetaData;
import org.jetbrains.annotations.Nullable;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
public @interface SQLField {
    public String value() default "";

    public boolean id() default false;

    public boolean isAutoIncrement() default false;

    public boolean notNull() default false;

    public IndexType index() default IndexType.NONE;

    public String sqlType() default "";

    public Class<? extends SQLTypeParser> parser() default SQLTypeParser.class;

    public String remapName() default "";

    public Order orderBy() default Order.NONE;

    public Serialize serialize() default Serialize.NONE;

    public String serializeName() default "";

    public static enum Serialize {
        NONE,
        TO_STRING{

            @Override
            public <T, I> Object serialize(SQLEntityFieldMetaData<T, I> fieldMetaData, Object o) {
                if (o == null) {
                    return null;
                }
                return o.toString();
            }
        }
        ,
        JSON{

            @Override
            public <T, I> Object serialize(SQLEntityFieldMetaData<T, I> fieldMetaData, Object o) {
                Gson gson = fieldMetaData.sqlibrary().gson();
                if (fieldMetaData.jsonSerializer() != null) {
                    JsonElement serialize = fieldMetaData.jsonSerializer().serialize(o, TypeToken.get(o.getClass()).getType(), fieldMetaData.sqlibrary().fieldJsonSerializationContext());
                    return serialize.toString();
                }
                return gson.toJson(o);
            }

            @Override
            public <I, T> void deserialize(SQLEntityFieldMetaData<I, T> fieldMetaData, ResultSet resultSet, I instance) throws SQLException {
                String data = resultSet.getString(fieldMetaData.fieldName());
                SQLibrary sqlibrary = fieldMetaData.sqlibrary();
                if (fieldMetaData.jsonSerializer() instanceof JsonDeserializer) {
                    JsonElement jsonElement = sqlibrary.gson().fromJson(data, JsonElement.class);
                    Object deserialize = ((JsonDeserializer)((Object)fieldMetaData.jsonSerializer())).deserialize(jsonElement, TypeToken.get(instance.getClass()).getType(), sqlibrary.fieldJsonDeserializationContext());
                    fieldMetaData.setValue(instance, deserialize);
                    return;
                }
                fieldMetaData.setValue(instance, sqlibrary.gson().fromJson(data, fieldMetaData.type()));
            }
        };


        @Nullable
        public <T, I> Object serialize(SQLEntityFieldMetaData<T, I> fieldMetaData, Object o) {
            return o;
        }

        public <I, T> void deserialize(SQLEntityFieldMetaData<I, T> fieldMetaData, ResultSet resultSet, I instance) throws SQLException {
            fieldMetaData.sqlType().transform(resultSet, fieldMetaData, instance);
        }
    }

    public static enum IndexType {
        NONE,
        INDEX,
        UNIQUE_KEY,
        PRIMARY_KEY,
        FULLTEXT_INDEX;


        public cc.carm.lib.easysql.api.enums.IndexType get() {
            switch (this) {
                case INDEX: {
                    return cc.carm.lib.easysql.api.enums.IndexType.INDEX;
                }
                default: {
                    return null;
                }
                case UNIQUE_KEY: {
                    return cc.carm.lib.easysql.api.enums.IndexType.UNIQUE_KEY;
                }
                case PRIMARY_KEY: {
                    return cc.carm.lib.easysql.api.enums.IndexType.PRIMARY_KEY;
                }
                case FULLTEXT_INDEX: 
            }
            return cc.carm.lib.easysql.api.enums.IndexType.FULLTEXT_INDEX;
        }
    }

    public static enum Order {
        NONE,
        ASC,
        DESC;

    }
}

