/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.util.sql.api;

import cc.carm.lib.easysql.EasySQL;
import cc.carm.lib.easysql.api.SQLManager;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.sql.DataSource;
import me.huanmeng.util.sql.api.SQLAsyncEntityManager;
import me.huanmeng.util.sql.api.SQLEntityManager;
import me.huanmeng.util.sql.gson.FieldJsonDeserializationContext;
import me.huanmeng.util.sql.gson.FieldJsonSerializationContext;
import me.huanmeng.util.sql.impl.SQLEntityInstance;
import me.huanmeng.util.sql.serialize.ValueSerialize;
import me.huanmeng.util.sql.type.SQLType;
import me.huanmeng.util.sql.type.SQLTypes;
import org.jetbrains.annotations.NotNull;

public class SQLibrary {
    protected final Map<Class<?>, SQLEntityInstance<?>> INSTANCE_MAP = new ConcurrentHashMap();
    protected DataSource dataSource;
    protected SQLTypes sqlTypes;
    protected Gson gson;
    protected FieldJsonSerializationContext fieldJsonSerializationContext;
    protected FieldJsonDeserializationContext fieldJsonDeserializationContext;
    protected boolean nullIgnore = true;
    protected Map<String, ValueSerialize> serializeMap;

    public SQLibrary(@NotNull DataSource dataSource) {
        this.dataSource = dataSource;
        this.sqlTypes = new SQLTypes();
        this.gson = new GsonBuilder().disableHtmlEscaping().create();
        this.fieldJsonSerializationContext = new FieldJsonSerializationContext(this.gson);
        this.fieldJsonDeserializationContext = new FieldJsonDeserializationContext(this.gson);
        this.serializeMap = new ConcurrentHashMap<String, ValueSerialize>();
    }

    @NotNull
    public <T> SQLEntityInstance<T> instanceOrCreate(@NotNull Class<T> clazz, @NotNull @NotNull Supplier<@NotNull SQLManager> sqlManager) {
        return this.INSTANCE_MAP.computeIfAbsent(clazz, c -> {
            try {
                return new SQLEntityInstance(this, c, (SQLManager)sqlManager.get());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @NotNull
    public <T> SQLEntityInstance<T> instance(@NotNull Class<T> clazz) {
        return this.instanceOrCreate(clazz, this.createManager());
    }

    @NotNull
    public <T> SQLEntityManager<T> manager(@NotNull Class<T> clazz) {
        return this.manager(clazz, this.createManager());
    }

    @NotNull
    public <T> SQLEntityManager<T> manager(@NotNull Class<T> clazz, @NotNull @NotNull Supplier<@NotNull SQLManager> sqlManager) {
        return this.instanceOrCreate(clazz, sqlManager).sqlEntityManager();
    }

    @NotNull
    public <T> SQLAsyncEntityManager<T> managerAsync(@NotNull Class<T> clazz) {
        return this.manager(clazz).async();
    }

    @NotNull
    public <T> SQLAsyncEntityManager<T> managerAsync(@NotNull Class<T> clazz, @NotNull @NotNull Supplier<@NotNull SQLManager> sqlManager) {
        return this.manager(clazz, sqlManager).async();
    }

    @NotNull
    public @NotNull Supplier<@NotNull SQLManager> createManager() {
        return () -> new SQLManagerImpl(this.dataSource);
    }

    @NotNull
    public @NotNull Supplier<@NotNull SQLManager> createManager(@NotNull DataSource dataSource) {
        return () -> new SQLManagerImpl(dataSource);
    }

    @NotNull
    public DataSource dataSource() {
        return this.dataSource;
    }

    @NotNull
    public SQLTypes sqlTypes() {
        return this.sqlTypes;
    }

    @NotNull
    public <T> SQLType<T> typeByClass(@NotNull Class<?> type) {
        return this.sqlTypes.getSQLType(type);
    }

    public boolean remove(@NotNull Class<?> clazz) {
        if (this.INSTANCE_MAP.containsKey(clazz)) {
            SQLEntityInstance<?> sqlEntityInstance = this.INSTANCE_MAP.get(clazz);
            EasySQL.shutdownManager(sqlEntityInstance.sqlManager());
            this.INSTANCE_MAP.remove(clazz);
            return true;
        }
        return false;
    }

    public boolean removeAll() {
        for (Map.Entry<Class<?>, SQLEntityInstance<?>> entry : this.INSTANCE_MAP.entrySet()) {
            SQLEntityInstance<?> sqlEntityInstance = entry.getValue();
            EasySQL.shutdownManager(sqlEntityInstance.sqlManager());
        }
        this.INSTANCE_MAP.clear();
        return true;
    }

    @NotNull
    public Gson gson() {
        return this.gson;
    }

    @NotNull
    public SQLibrary gson(@NotNull Gson gson) {
        this.gson = gson;
        return this;
    }

    public SQLibrary dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public SQLibrary sqlTypes(SQLTypes sqlTypes) {
        this.sqlTypes = sqlTypes;
        return this;
    }

    public FieldJsonSerializationContext fieldJsonSerializationContext() {
        return this.fieldJsonSerializationContext;
    }

    public SQLibrary fieldJsonSerializationContext(FieldJsonSerializationContext fieldJsonSerializationContext) {
        this.fieldJsonSerializationContext = fieldJsonSerializationContext;
        return this;
    }

    public FieldJsonDeserializationContext fieldJsonDeserializationContext() {
        return this.fieldJsonDeserializationContext;
    }

    public SQLibrary fieldJsonDeserializationContext(@NotNull FieldJsonDeserializationContext fieldJsonDeserializationContext) {
        this.fieldJsonDeserializationContext = fieldJsonDeserializationContext;
        return this;
    }

    public boolean nullIgnore() {
        return this.nullIgnore;
    }

    public SQLibrary nullIgnore(boolean nullIgnore) {
        this.nullIgnore = nullIgnore;
        return this;
    }

    public Map<String, ValueSerialize> serializeMap() {
        return this.serializeMap;
    }

    public SQLibrary addSerialize(@NotNull String name, @NotNull ValueSerialize serialize) {
        this.serializeMap.put(name, serialize);
        return this;
    }

    public SQLibrary removeSerialize(@NotNull String name) {
        this.serializeMap.remove(name);
        return this;
    }

    public ValueSerialize getSerialize(@NotNull String name) {
        return this.serializeMap.get(name);
    }
}

