/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.builder.impl;

import cc.carm.lib.easysql.action.SQLUpdateActionImpl;
import cc.carm.lib.easysql.api.SQLAction;
import cc.carm.lib.easysql.api.SQLBuilder;
import cc.carm.lib.easysql.api.builder.TableAlterBuilder;
import cc.carm.lib.easysql.api.enums.IndexType;
import cc.carm.lib.easysql.builder.AbstractSQLBuilder;
import cc.carm.lib.easysql.builder.impl.TableCreateBuilderImpl;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableAlterBuilderImpl
extends AbstractSQLBuilder
implements TableAlterBuilder {
    @NotNull
    protected final String tableName;

    public TableAlterBuilderImpl(@NotNull SQLManagerImpl manager, @NotNull String tableName) {
        super(manager);
        this.tableName = tableName;
    }

    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public SQLAction<Integer> renameTo(@NotNull String newTableName) {
        Objects.requireNonNull(newTableName, "table name could not be null");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.tableName) + " RENAME TO " + SQLBuilder.withBackQuote(newTableName));
    }

    @Override
    public SQLAction<Integer> changeComment(@NotNull String newTableComment) {
        Objects.requireNonNull(newTableComment, "table comment could not be null");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " COMMENT " + SQLBuilder.withQuote(newTableComment));
    }

    @Override
    public SQLAction<Integer> setAutoIncrementIndex(int index) {
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " AUTO_INCREMENT=" + index);
    }

    @Override
    public SQLAction<Integer> addIndex(@NotNull IndexType indexType, @Nullable String indexName, @NotNull String columnName, String ... moreColumns) {
        Objects.requireNonNull(indexType, "indexType could not be null");
        Objects.requireNonNull(columnName, "column names could not be null");
        Objects.requireNonNull(moreColumns, "column names could not be null");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " ADD " + TableCreateBuilderImpl.buildIndexSettings(indexType, indexName, columnName, moreColumns));
    }

    @Override
    public SQLAction<Integer> dropIndex(@NotNull String indexName) {
        Objects.requireNonNull(indexName, "indexName could not be null");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " DROP INDEX " + SQLBuilder.withBackQuote(indexName));
    }

    @Override
    public SQLAction<Integer> dropForeignKey(@NotNull String keySymbol) {
        Objects.requireNonNull(keySymbol, "keySymbol could not be null");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " DROP FOREIGN KEY " + SQLBuilder.withBackQuote(keySymbol));
    }

    @Override
    public SQLAction<Integer> dropPrimaryKey() {
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " DROP PRIMARY KEY");
    }

    @Override
    public SQLAction<Integer> addColumn(@NotNull String columnName, @NotNull String settings, @Nullable String afterColumn) {
        Objects.requireNonNull(columnName, "columnName could not be null");
        Objects.requireNonNull(settings, "settings could not be null");
        String orderSettings = null;
        if (afterColumn != null) {
            orderSettings = afterColumn.length() > 0 ? "AFTER " + SQLBuilder.withBackQuote(afterColumn) : "FIRST";
        }
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " ADD " + SQLBuilder.withBackQuote(columnName) + " " + settings + (orderSettings != null ? " " + orderSettings : ""));
    }

    @Override
    public SQLAction<Integer> renameColumn(@NotNull String columnName, @NotNull String newName) {
        Objects.requireNonNull(columnName, "columnName could not be null");
        Objects.requireNonNull(newName, "please specify new column name");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " RENAME COLUMN " + SQLBuilder.withBackQuote(columnName) + " TO " + SQLBuilder.withBackQuote(newName));
    }

    @Override
    public SQLAction<Integer> modifyColumn(@NotNull String columnName, @NotNull String settings) {
        Objects.requireNonNull(columnName, "columnName could not be null");
        Objects.requireNonNull(settings, "please specify new column settings");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " MODIFY COLUMN " + SQLBuilder.withBackQuote(columnName) + " " + settings);
    }

    @Override
    public SQLAction<Integer> removeColumn(@NotNull String columnName) {
        Objects.requireNonNull(columnName, "columnName could not be null");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " DROP " + SQLBuilder.withBackQuote(columnName));
    }

    @Override
    public SQLAction<Integer> setColumnDefault(@NotNull String columnName, @NotNull String defaultValue) {
        Objects.requireNonNull(columnName, "columnName could not be null");
        Objects.requireNonNull(defaultValue, "defaultValue could not be null, if you need to remove the default value, please use #removeColumnDefault().");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " ALTER " + SQLBuilder.withBackQuote(columnName) + " SET DEFAULT " + defaultValue);
    }

    @Override
    public SQLAction<Integer> removeColumnDefault(@NotNull String columnName) {
        Objects.requireNonNull(columnName, "columnName could not be null");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " ALTER " + SQLBuilder.withBackQuote(columnName) + " DROP DEFAULT");
    }

    private SQLUpdateActionImpl<Integer> createAction(@NotNull String sql) {
        return new SQLUpdateActionImpl<Integer>(this.getManager(), Integer.class, sql);
    }
}

