/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.builder.impl;

import cc.carm.lib.easysql.action.PreparedSQLUpdateActionImpl;
import cc.carm.lib.easysql.api.SQLAction;
import cc.carm.lib.easysql.api.SQLBuilder;
import cc.carm.lib.easysql.api.action.PreparedSQLUpdateAction;
import cc.carm.lib.easysql.api.builder.DeleteBuilder;
import cc.carm.lib.easysql.builder.impl.AbstractConditionalBuilder;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DeleteBuilderImpl
extends AbstractConditionalBuilder<DeleteBuilder, SQLAction<Integer>>
implements DeleteBuilder {
    protected final String tableName;

    public DeleteBuilderImpl(@NotNull SQLManagerImpl manager, @NotNull String tableName) {
        super(manager);
        Objects.requireNonNull(tableName);
        this.tableName = tableName;
    }

    @Override
    public PreparedSQLUpdateAction<Integer> build() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("DELETE FROM ").append(SQLBuilder.withBackQuote(this.getTableName()));
        if (this.hasConditions()) {
            sqlBuilder.append(" ").append(this.buildConditionSQL());
        }
        if (this.limit > 0) {
            sqlBuilder.append(" ").append(this.buildLimitSQL());
        }
        return new PreparedSQLUpdateActionImpl<Integer>(this.getManager(), Integer.class, sqlBuilder.toString(), this.hasConditionParams() ? this.getConditionParams() : null);
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    protected DeleteBuilderImpl getThis() {
        return this;
    }
}

