/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.beecp;

import cc.carm.lib.easysql.beecp.BeeDataSourceConfig;
import cc.carm.lib.easysql.beecp.pool.ConnectionPool;
import cc.carm.lib.easysql.beecp.pool.ConnectionPoolMonitorVo;
import cc.carm.lib.easysql.beecp.pool.PoolStaticCenter;
import cc.carm.lib.easysql.beecp.pool.exception.PoolCreateFailedException;
import cc.carm.lib.easysql.beecp.pool.exception.PoolNotCreateException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeeDataSource
extends BeeDataSourceConfig
implements DataSource,
XADataSource {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private ConnectionPool pool;
    private boolean ready;
    private SQLException failedCause;

    public BeeDataSource() {
    }

    public BeeDataSource(String driver, String url, String user, String password) {
        super(driver, url, user, password);
    }

    public BeeDataSource(BeeDataSourceConfig config) {
        try {
            config.copyTo(this);
            BeeDataSource.createPool(this);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static ConnectionPool createPool(BeeDataSource ds) throws SQLException {
        try {
            Class<?> poolClass = Class.forName(ds.getPoolImplementClassName());
            ConnectionPool pool = (ConnectionPool)PoolStaticCenter.createClassInstance(poolClass, ConnectionPool.class, "pool");
            pool.init(ds);
            ds.pool = pool;
            ds.ready = true;
            return pool;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PoolCreateFailedException("Failed to create connection pool by class:" + ds.getPoolImplementClassName(), e);
        }
    }

    @Override
    public final Connection getConnection() throws SQLException {
        if (this.ready) {
            return this.pool.getConnection();
        }
        return this.createPoolByLock().getConnection();
    }

    @Override
    public final XAConnection getXAConnection() throws SQLException {
        if (this.ready) {
            return this.pool.getXAConnection();
        }
        return this.createPoolByLock().getXAConnection();
    }

    /*
     * Unable to fully structure code
     */
    private ConnectionPool createPoolByLock() throws SQLException {
        if (this.writeLock.tryLock()) {
            try {
                if (this.ready) ** GOTO lbl20
                this.failedCause = null;
                BeeDataSource.createPool(this);
            }
            catch (SQLException e) {
                this.failedCause = e;
            }
            finally {
                this.writeLock.unlock();
            }
        } else {
            try {
                this.readLock.lock();
            }
            finally {
                this.readLock.unlock();
            }
        }
        if (this.failedCause != null) {
            throw this.failedCause;
        }
        return this.pool;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not support");
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not support");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz != null && clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz != null && clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        throw new SQLException("Wrapped object was not an instance of " + clazz);
    }

    public void clear() throws SQLException {
        this.clear(false);
    }

    public void clear(boolean force) throws SQLException {
        if (this.pool == null) {
            throw new PoolNotCreateException("Connection pool not initialize");
        }
        this.pool.clear(force);
    }

    public boolean isClosed() {
        return this.pool == null || this.pool.isClosed();
    }

    public void close() {
        if (this.pool != null) {
            try {
                this.pool.close();
            }
            catch (Throwable e) {
                PoolStaticCenter.CommonLog.error("Error at closing connection pool,cause:", e);
            }
        }
    }

    @Override
    public void setPrintRuntimeLog(boolean printRuntimeLog) {
        if (this.pool != null) {
            this.pool.setPrintRuntimeLog(printRuntimeLog);
        }
    }

    public ConnectionPoolMonitorVo getPoolMonitorVo() throws SQLException {
        if (this.pool == null) {
            throw new PoolNotCreateException("Connection pool not initialize");
        }
        return this.pool.getPoolMonitorVo();
    }
}

