/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.api.function;

import java.sql.SQLException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface SQLFunction<T, R> {
    @Nullable
    public R apply(@NotNull T var1) throws SQLException;

    default public <V> SQLFunction<V, R> compose(@NotNull SQLFunction<? super V, ? extends T> before) {
        Objects.requireNonNull(before);
        return v -> {
            R t = before.apply((Object)v);
            if (t == null) {
                return null;
            }
            return this.apply(t);
        };
    }

    default public <V> SQLFunction<T, V> then(@NotNull SQLFunction<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        return t -> {
            R r = this.apply(t);
            if (r == null) {
                return null;
            }
            return after.apply((R)r);
        };
    }
}

