/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.api;

import cc.carm.lib.easysql.api.SQLQuery;
import cc.carm.lib.easysql.api.action.PreparedSQLUpdateAction;
import cc.carm.lib.easysql.api.action.PreparedSQLUpdateBatchAction;
import cc.carm.lib.easysql.api.builder.DeleteBuilder;
import cc.carm.lib.easysql.api.builder.InsertBuilder;
import cc.carm.lib.easysql.api.builder.QueryBuilder;
import cc.carm.lib.easysql.api.builder.ReplaceBuilder;
import cc.carm.lib.easysql.api.builder.TableAlterBuilder;
import cc.carm.lib.easysql.api.builder.TableCreateBuilder;
import cc.carm.lib.easysql.api.builder.TableMetadataBuilder;
import cc.carm.lib.easysql.api.builder.UpdateBuilder;
import cc.carm.lib.easysql.api.function.SQLBiFunction;
import cc.carm.lib.easysql.api.function.SQLDebugHandler;
import cc.carm.lib.easysql.api.function.SQLExceptionHandler;
import cc.carm.lib.easysql.api.function.SQLFunction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public interface SQLManager {
    public Logger getLogger();

    public boolean isDebugMode();

    @NotNull
    public ExecutorService getExecutorPool();

    public void setExecutorPool(@NotNull ExecutorService var1);

    public static ExecutorService defaultExecutorPool(String threadName) {
        return Executors.newFixedThreadPool(4, r -> {
            Thread thread = new Thread(r, threadName);
            thread.setDaemon(true);
            return thread;
        });
    }

    public void setDebugMode(@NotNull @NotNull Supplier<@NotNull Boolean> var1);

    default public void setDebugMode(boolean enable) {
        this.setDebugMode(() -> enable);
    }

    @NotNull
    public SQLDebugHandler getDebugHandler();

    public void setDebugHandler(@NotNull SQLDebugHandler var1);

    @NotNull
    public DataSource getDataSource();

    @NotNull
    public Connection getConnection() throws SQLException;

    @NotNull
    public Map<UUID, SQLQuery> getActiveQuery();

    @NotNull
    public SQLExceptionHandler getExceptionHandler();

    public void setExceptionHandler(@Nullable SQLExceptionHandler var1);

    @Nullable
    public Integer executeSQL(String var1);

    @Nullable
    public Integer executeSQL(String var1, Object[] var2);

    @Nullable
    public List<Integer> executeSQLBatch(String var1, Iterable<Object[]> var2);

    @Nullable
    public List<Integer> executeSQLBatch(@NotNull String var1, String ... var2);

    @Nullable
    public List<Integer> executeSQLBatch(@NotNull Iterable<String> var1);

    default public <R> CompletableFuture<R> fetchMetadata(@NotNull SQLFunction<DatabaseMetaData, R> reader) {
        return this.fetchMetadata((DatabaseMetaData meta, Connection conn) -> reader.apply((DatabaseMetaData)meta));
    }

    default public <R> CompletableFuture<R> fetchMetadata(@NotNull SQLFunction<DatabaseMetaData, ResultSet> supplier, @NotNull @NotNull SQLFunction<@NotNull ResultSet, R> reader) {
        return this.fetchMetadata((DatabaseMetaData meta, Connection conn) -> (ResultSet)supplier.apply((DatabaseMetaData)meta), reader);
    }

    public <R> CompletableFuture<R> fetchMetadata(@NotNull SQLBiFunction<DatabaseMetaData, Connection, R> var1);

    public <R> CompletableFuture<R> fetchMetadata(@NotNull SQLBiFunction<DatabaseMetaData, Connection, ResultSet> var1, @NotNull @NotNull SQLFunction<@NotNull ResultSet, R> var2);

    public TableCreateBuilder createTable(@NotNull String var1);

    public TableAlterBuilder alterTable(@NotNull String var1);

    public TableMetadataBuilder fetchTableMetadata(@NotNull String var1);

    public QueryBuilder createQuery();

    public InsertBuilder<PreparedSQLUpdateAction<Integer>> createInsert(@NotNull String var1);

    public InsertBuilder<PreparedSQLUpdateBatchAction<Integer>> createInsertBatch(@NotNull String var1);

    public ReplaceBuilder<PreparedSQLUpdateAction<Integer>> createReplace(@NotNull String var1);

    public ReplaceBuilder<PreparedSQLUpdateBatchAction<Integer>> createReplaceBatch(@NotNull String var1);

    public UpdateBuilder createUpdate(@NotNull String var1);

    public DeleteBuilder createDelete(@NotNull String var1);
}

