/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.action.query;

import cc.carm.lib.easysql.action.AbstractSQLAction;
import cc.carm.lib.easysql.api.SQLQuery;
import cc.carm.lib.easysql.api.action.query.QueryAction;
import cc.carm.lib.easysql.api.function.SQLExceptionHandler;
import cc.carm.lib.easysql.api.function.SQLHandler;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import cc.carm.lib.easysql.query.SQLQueryImpl;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class QueryActionImpl
extends AbstractSQLAction<SQLQuery>
implements QueryAction {
    public QueryActionImpl(@NotNull SQLManagerImpl manager, @NotNull String sql) {
        super(manager, sql);
    }

    @Override
    @NotNull
    public SQLQueryImpl execute() throws SQLException {
        Statement statement;
        this.debugMessage(new ArrayList<Object[]>());
        Connection connection = this.getManager().getConnection();
        try {
            statement = connection.createStatement();
        }
        catch (SQLException ex) {
            connection.close();
            throw ex;
        }
        try {
            SQLQueryImpl query = new SQLQueryImpl(this.getManager(), this, connection, statement, statement.executeQuery(this.getSQLContent()));
            this.getManager().getActiveQuery().put(this.getActionUUID(), query);
            return query;
        }
        catch (SQLException exception) {
            statement.close();
            connection.close();
            throw exception;
        }
    }

    @Override
    public void executeAsync(SQLHandler<SQLQuery> success, SQLExceptionHandler failure) {
        this.getManager().getExecutorPool().submit(() -> {
            try (SQLQueryImpl query = this.execute();){
                if (success != null) {
                    success.accept(query);
                }
            }
            catch (SQLException exception) {
                this.handleException(failure, exception);
            }
        });
    }
}

