/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.ssl;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientSslConfigImpl;
import com.hivemq.client.internal.util.collections.ImmutableList;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.net.InetSocketAddress;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import org.jetbrains.annotations.NotNull;

public final class MqttSslInitializer {
    @NotNull
    private static final String SSL_HANDLER_NAME = "ssl";

    public static void initChannel(@NotNull Channel channel, @NotNull MqttClientConfig clientConfig, @NotNull MqttClientSslConfigImpl sslConfig, @NotNull Consumer<Channel> onSuccess, @NotNull BiConsumer<Channel, Throwable> onError) {
        SslHandler sslHandler;
        InetSocketAddress serverAddress = clientConfig.getCurrentTransportConfig().getServerAddress();
        try {
            SslContext sslContext = clientConfig.getCurrentSslContext();
            if (sslContext == null) {
                sslContext = MqttSslInitializer.createSslContext(sslConfig);
                clientConfig.setCurrentSslContext(sslContext);
            }
            sslHandler = sslContext.newHandler(channel.alloc(), serverAddress.getHostString(), serverAddress.getPort());
        }
        catch (Throwable t) {
            onError.accept(channel, t);
            return;
        }
        sslHandler.setHandshakeTimeoutMillis(sslConfig.getHandshakeTimeoutMs());
        HostnameVerifier hostnameVerifier = sslConfig.getRawHostnameVerifier();
        if (hostnameVerifier == null) {
            SSLParameters sslParameters = sslHandler.engine().getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslHandler.engine().setSSLParameters(sslParameters);
        }
        sslHandler.handshakeFuture().addListener(future -> {
            if (future.isSuccess()) {
                if (hostnameVerifier != null && !hostnameVerifier.verify(serverAddress.getHostString(), sslHandler.engine().getSession())) {
                    onError.accept(channel, new SSLHandshakeException("Hostname verification failed"));
                } else {
                    onSuccess.accept(channel);
                }
            } else {
                onError.accept(channel, future.cause());
            }
        });
        channel.pipeline().addLast(SSL_HANDLER_NAME, (ChannelHandler)sslHandler);
    }

    @NotNull
    static SslContext createSslContext(@NotNull MqttClientSslConfigImpl sslConfig) throws SSLException {
        ImmutableList<String> protocols = sslConfig.getRawProtocols();
        return SslContextBuilder.forClient().trustManager(sslConfig.getRawTrustManagerFactory()).keyManager(sslConfig.getRawKeyManagerFactory()).protocols(protocols == null ? null : protocols.toArray(new String[0])).ciphers(sslConfig.getRawCipherSuites(), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).build();
    }

    private MqttSslInitializer() {
    }
}

