/*
 * Decompiled with CFR 0.152.
 */
package com.hellokaton.blade.asm;

import com.hellokaton.blade.asm.method.MethodVisitor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.objectweb.asm.ClassReader;

public final class ASMUtils {
    private static final Map<Method, String[]> METHOD_NAMES_POOL = new ConcurrentHashMap<Method, String[]>(64);

    public static String[] findMethodParmeterNames(Method method) {
        ClassReader cr;
        if (METHOD_NAMES_POOL.containsKey(method)) {
            return METHOD_NAMES_POOL.get(method);
        }
        String n = method.getDeclaringClass().getName();
        try {
            cr = new ClassReader(n);
        }
        catch (IOException e) {
            return null;
        }
        MethodVisitor methodVisitor = new MethodVisitor(method.getDeclaringClass(), method.getName(), method.getParameterTypes());
        cr.accept(methodVisitor, 0);
        String[] paramNames = methodVisitor.getParamNames();
        METHOD_NAMES_POOL.put(method, paramNames);
        return paramNames;
    }
}

