/*
 * Decompiled with CFR 0.152.
 */
package com.hcyacg.protocol.event.message.directMessage;

import com.google.gson.Gson;
import com.hcyacg.protocol.constant.Constant;
import com.hcyacg.protocol.entity.Message;
import com.hcyacg.protocol.event.api.Dms;
import com.hcyacg.protocol.event.api.DmsDto;
import com.hcyacg.protocol.event.api.ImageMessage;
import com.hcyacg.protocol.event.api.TextMessage;
import com.hcyacg.protocol.event.api.TextWithImageMessage;
import com.hcyacg.protocol.event.api.initiativeImageMessage;
import com.hcyacg.protocol.event.api.initiativeTextMessage;
import com.hcyacg.protocol.event.api.initiativeTextWithImageMessage;
import com.hcyacg.protocol.event.message.directMessage.DirectMessage;
import com.hcyacg.protocol.utils.OkHttpUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\fH\u0002J\u0016\u0010\u0005\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0004J\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004J\u001e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004J\u001e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J&\u0010\u0017\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/hcyacg/protocol/event/message/directMessage/DmsApi;", "Lcom/hcyacg/protocol/event/message/directMessage/DirectMessage;", "()V", "dms", "", "recall", "sendMessage", "createDms", "Lcom/hcyacg/protocol/event/api/Dms;", "authorId", "guildId", "officeApiHeader", "", "", "messageId", "replyImage", "Lcom/hcyacg/protocol/entity/Message;", "imageUrl", "replyText", "msg", "replyTextWithImage", "sendImage", "sendText", "sendTextWithImage", "tencent-guild-protocol"})
public class DmsApi
extends DirectMessage {
    @NotNull
    private final String sendMessage;
    @NotNull
    private final String dms;
    @NotNull
    private final String recall;

    public DmsApi() {
        this.sendMessage = "https://api.sgroup.qq.com/dms/{{guild_id}}/messages";
        this.dms = "https://api.sgroup.qq.com/users/@me/dms";
        this.recall = "https://api.sgroup.qq.com/dms/{{guild_id}}/messages/{{message_id}}";
    }

    private final Map<String, String> officeApiHeader() {
        Pair[] pairArray = new Pair[1];
        String string = Constant.Companion.getBotToken();
        Intrinsics.checkNotNull((Object)string);
        pairArray[0] = TuplesKt.to((Object)"Authorization", (Object)string);
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    private final Dms createDms(String authorId, String guildId) {
        String json = new Gson().toJson((Object)new DmsDto(authorId, guildId));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(this.dms, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Dms.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Dms::class.java)");
        return (Dms)object;
    }

    @NotNull
    public final Message replyText(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        String url = StringsKt.replace$default((String)this.sendMessage, (String)"{{guild_id}}", (String)this.getGuildId(), (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new TextMessage(msg, this.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Message.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Message::class.java)");
        return (Message)object;
    }

    @NotNull
    public final Message sendText(@NotNull String authorId, @NotNull String guildId, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)authorId, (String)"authorId");
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Dms createDms = this.createDms(authorId, guildId);
        String url = StringsKt.replace$default((String)this.sendMessage, (String)"{{guild_id}}", (String)createDms.getGuildId(), (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new initiativeTextMessage(msg));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Message.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Message::class.java)");
        return (Message)object;
    }

    @NotNull
    public final Message replyTextWithImage(@NotNull String msg, @NotNull String imageUrl) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        String url = StringsKt.replace$default((String)this.sendMessage, (String)"{{guild_id}}", (String)this.getGuildId(), (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new TextWithImageMessage(msg, imageUrl, this.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Message.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Message::class.java)");
        return (Message)object;
    }

    @NotNull
    public final Message sendTextWithImage(@NotNull String authorId, @NotNull String guildId, @NotNull String msg, @NotNull String imageUrl) {
        Intrinsics.checkNotNullParameter((Object)authorId, (String)"authorId");
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        Dms createDms = this.createDms(authorId, guildId);
        String url = StringsKt.replace$default((String)this.sendMessage, (String)"{{guild_id}}", (String)createDms.getGuildId(), (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new initiativeTextWithImageMessage(msg, imageUrl));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Message.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Message::class.java)");
        return (Message)object;
    }

    @NotNull
    public final Message replyImage(@NotNull String imageUrl) {
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        String url = StringsKt.replace$default((String)this.sendMessage, (String)"{{guild_id}}", (String)this.getGuildId(), (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new ImageMessage(imageUrl, this.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Message.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Message::class.java)");
        return (Message)object;
    }

    @NotNull
    public final Message sendImage(@NotNull String authorId, @NotNull String guildId, @NotNull String imageUrl) {
        Intrinsics.checkNotNullParameter((Object)authorId, (String)"authorId");
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        Dms createDms = this.createDms(authorId, guildId);
        String url = StringsKt.replace$default((String)this.sendMessage, (String)"{{guild_id}}", (String)createDms.getGuildId(), (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new initiativeImageMessage(imageUrl));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Message.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Message::class.java)");
        return (Message)object;
    }

    public final boolean recall(@NotNull String guildId, @NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)this.recall, (String)"{{guild_id}}", (String)guildId, (boolean)false, (int)4, null), (String)"{{message_id}}", (String)messageId, (boolean)false, (int)4, null);
        Response res = OkHttpUtils.INSTANCE.delete(url, (Map<String, String>)new LinkedHashMap(), this.officeApiHeader());
        Constant.Companion.getLogger().debug(String.valueOf(res.code()));
        return res.code() == 200;
    }
}

