/*
 * Decompiled with CFR 0.152.
 */
package com.hcyacg.protocol.event.message;

import com.google.gson.Gson;
import com.hcyacg.protocol.constant.Constant;
import com.hcyacg.protocol.entity.AudioControl;
import com.hcyacg.protocol.entity.Message;
import com.hcyacg.protocol.event.api.ArkMessage;
import com.hcyacg.protocol.event.api.EmbedMessage;
import com.hcyacg.protocol.event.api.ImageMessage;
import com.hcyacg.protocol.event.api.MessageArk;
import com.hcyacg.protocol.event.api.MessageEmbed;
import com.hcyacg.protocol.event.api.TextMessage;
import com.hcyacg.protocol.event.api.TextWithImageMessage;
import com.hcyacg.protocol.event.api.initiativeArkMessage;
import com.hcyacg.protocol.event.api.initiativeEmbedMessage;
import com.hcyacg.protocol.event.api.initiativeImageMessage;
import com.hcyacg.protocol.event.api.initiativeTextMessage;
import com.hcyacg.protocol.event.api.initiativeTextWithImageMessage;
import com.hcyacg.protocol.event.message.MessageEvent;
import com.hcyacg.protocol.utils.OkHttpUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0011H\u0002J\u0006\u0010\b\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0004J\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0004J\u0016\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\t\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\rJ\u000e\u0010\"\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010#\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0004J\u000e\u0010$\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0004J\u0016\u0010%\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/hcyacg/protocol/event/message/EventApi;", "Lcom/hcyacg/protocol/event/message/MessageEvent;", "()V", "channel", "", "guildInfo", "memberMute", "mute", "recall", "sendAudio", "sendMessage", "", "seconds", "", "timestamp", "", "officeApiHeader", "", "replyArk", "Lcom/hcyacg/protocol/entity/Message;", "messageArk", "Lcom/hcyacg/protocol/event/api/MessageArk;", "replyEmbed", "messageEmbed", "Lcom/hcyacg/protocol/event/api/MessageEmbed;", "replyImage", "imageUrl", "replyText", "msg", "replyTextWithImage", "sendArk", "audioUrl", "text", "status", "sendEmbed", "sendImage", "sendText", "sendTextWithImage", "tencent-guild-protocol"})
public class EventApi
extends MessageEvent {
    @NotNull
    private final String channel;
    @NotNull
    private final String sendMessage;
    @NotNull
    private final String sendAudio;
    @NotNull
    private final String recall;
    @NotNull
    private final String guildInfo;
    @NotNull
    private final String memberMute;
    @NotNull
    private final String mute;

    public EventApi() {
        this.channel = "https://api.sgroup.qq.com/channels/{{channel_id}}";
        this.sendMessage = this.channel + "/messages";
        this.sendAudio = this.channel + "/audio";
        this.recall = this.sendMessage + "/{{message_id}}";
        this.guildInfo = "https://api.sgroup.qq.com/guilds/{{guild_id}}";
        this.memberMute = this.guildInfo + "/members/{{user_id}}/mute";
        this.mute = "https://api.sgroup.qq.com/guilds/{{guild_id}}/mute";
    }

    private final Map<String, String> officeApiHeader() {
        Pair[] pairArray = new Pair[1];
        String string = Constant.Companion.getBotToken();
        Intrinsics.checkNotNull((Object)string);
        pairArray[0] = TuplesKt.to((Object)"Authorization", (Object)string);
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @NotNull
    public final Message replyText(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        String url = StringsKt.replace$default((String)this.sendMessage, (String)"{{channel_id}}", (String)this.getChannelId(), (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new TextMessage(msg, this.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Message.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Message::class.java)");
        return (Message)object;
    }

    @NotNull
    public final Message sendText(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        String url = StringsKt.replace$default((String)this.sendMessage, (String)"{{channel_id}}", (String)this.getChannelId(), (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new initiativeTextMessage(msg));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Message.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Message::class.java)");
        return (Message)object;
    }

    @NotNull
    public final Message replyTextWithImage(@NotNull String msg, @NotNull String imageUrl) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        String url = StringsKt.replace$default((String)this.sendMessage, (String)"{{channel_id}}", (String)this.getChannelId(), (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new TextWithImageMessage(msg, imageUrl, this.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Message.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Message::class.java)");
        return (Message)object;
    }

    @NotNull
    public final Message sendTextWithImage(@NotNull String msg, @NotNull String imageUrl) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        String url = StringsKt.replace$default((String)this.sendMessage, (String)"{{channel_id}}", (String)this.getChannelId(), (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new initiativeTextWithImageMessage(msg, imageUrl));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Message.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Message::class.java)");
        return (Message)object;
    }

    @NotNull
    public final Message replyImage(@NotNull String imageUrl) {
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        String url = StringsKt.replace$default((String)this.sendMessage, (String)"{{channel_id}}", (String)this.getChannelId(), (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new ImageMessage(imageUrl, this.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Message.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Message::class.java)");
        return (Message)object;
    }

    @NotNull
    public final Message sendImage(@NotNull String imageUrl) {
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        String url = StringsKt.replace$default((String)this.sendMessage, (String)"{{channel_id}}", (String)this.getChannelId(), (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new initiativeImageMessage(imageUrl));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Message.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Message::class.java)");
        return (Message)object;
    }

    @NotNull
    public final Message replyArk(@NotNull MessageArk messageArk) {
        Intrinsics.checkNotNullParameter((Object)messageArk, (String)"messageArk");
        String url = StringsKt.replace$default((String)this.sendMessage, (String)"{{channel_id}}", (String)this.getChannelId(), (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new ArkMessage(messageArk, this.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Message.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Message::class.java)");
        return (Message)object;
    }

    @NotNull
    public final Message sendArk(@NotNull MessageArk messageArk) {
        Intrinsics.checkNotNullParameter((Object)messageArk, (String)"messageArk");
        String url = StringsKt.replace$default((String)this.sendMessage, (String)"{{channel_id}}", (String)this.getChannelId(), (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new initiativeArkMessage(messageArk));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Message.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Message::class.java)");
        return (Message)object;
    }

    @NotNull
    public final Message replyEmbed(@NotNull MessageEmbed messageEmbed) {
        Intrinsics.checkNotNullParameter((Object)messageEmbed, (String)"messageEmbed");
        String url = StringsKt.replace$default((String)this.sendMessage, (String)"{{channel_id}}", (String)this.getChannelId(), (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new EmbedMessage(messageEmbed, this.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Message.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Message::class.java)");
        return (Message)object;
    }

    @NotNull
    public final Message sendEmbed(@NotNull MessageEmbed messageEmbed) {
        Intrinsics.checkNotNullParameter((Object)messageEmbed, (String)"messageEmbed");
        String url = StringsKt.replace$default((String)this.sendMessage, (String)"{{channel_id}}", (String)this.getChannelId(), (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new initiativeEmbedMessage(messageEmbed));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Message.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Message::class.java)");
        return (Message)object;
    }

    @NotNull
    public final Message sendAudio(@NotNull String audioUrl, @NotNull String text, int status) {
        Intrinsics.checkNotNullParameter((Object)audioUrl, (String)"audioUrl");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String url = StringsKt.replace$default((String)this.sendAudio, (String)"{{channel_id}}", (String)this.getChannelId(), (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new AudioControl(audioUrl, text, status));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Message.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Message::class.java)");
        return (Message)object;
    }

    public final boolean mute(long timestamp) {
        String url = StringsKt.replace$default((String)this.mute, (String)"{{guild_id}}", (String)this.getGuildId(), (boolean)false, (int)4, null);
        String json = "{\"mute_end_timestamp\": " + timestamp + "}";
        Response res = OkHttpUtils.INSTANCE.patch(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(String.valueOf(res.code()));
        return res.code() == 204;
    }

    public final boolean mute(int seconds) {
        String url = StringsKt.replace$default((String)this.mute, (String)"{{guild_id}}", (String)this.getGuildId(), (boolean)false, (int)4, null);
        String json = "{\"mute_seconds\": " + seconds + "}";
        Response res = OkHttpUtils.INSTANCE.patch(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(String.valueOf(res.code()));
        return res.code() == 204;
    }

    public final boolean recall() {
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)this.recall, (String)"{{channel_id}}", (String)this.getChannelId(), (boolean)false, (int)4, null), (String)"{{message_id}}", (String)this.getId(), (boolean)false, (int)4, null);
        Response res = OkHttpUtils.INSTANCE.delete(url, (Map<String, String>)new LinkedHashMap(), this.officeApiHeader());
        Constant.Companion.getLogger().debug(String.valueOf(res.code()));
        return res.code() == 200;
    }
}

