/*
 * Decompiled with CFR 0.152.
 */
package com.hcyacg.protocol.event.api;

import com.google.gson.annotations.SerializedName;
import com.hcyacg.protocol.anno.NoArg;
import com.hcyacg.protocol.constant.Constant;
import com.hcyacg.protocol.utils.OkHttpUtils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@NoArg
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001dH\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0006\"\u0004\b\u0012\u0010\bR\u000e\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0006\"\u0004\b\u0016\u0010\b\u00a8\u0006\u001e"}, d2={"Lcom/hcyacg/protocol/event/api/Author;", "", "()V", "avatar", "", "getAvatar", "()Ljava/lang/String;", "setAvatar", "(Ljava/lang/String;)V", "bot", "", "getBot", "()Z", "setBot", "(Z)V", "guildInfo", "id", "getId", "setId", "memberMute", "username", "getUsername", "setUsername", "mute", "seconds", "", "timestamp", "", "officeApiHeader", "", "tencent-guild-protocol"})
public class Author {
    @SerializedName(value="avatar")
    public String avatar;
    @SerializedName(value="bot")
    private boolean bot;
    @SerializedName(value="id")
    public String id;
    @SerializedName(value="username")
    public String username;
    @NotNull
    private final String guildInfo;
    @NotNull
    private final String memberMute;

    public Author() {
        this.guildInfo = "https://api.sgroup.qq.com/guilds/{{guild_id}}";
        this.memberMute = this.guildInfo + "/members/{{user_id}}/mute";
    }

    @NotNull
    public final String getAvatar() {
        String string = this.avatar;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"avatar");
        return null;
    }

    public final void setAvatar(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.avatar = string;
    }

    public final boolean getBot() {
        return this.bot;
    }

    public final void setBot(boolean bl) {
        this.bot = bl;
    }

    @NotNull
    public final String getId() {
        String string = this.id;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"id");
        return null;
    }

    public final void setId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.id = string;
    }

    @NotNull
    public final String getUsername() {
        String string = this.username;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"username");
        return null;
    }

    public final void setUsername(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.username = string;
    }

    private final Map<String, String> officeApiHeader() {
        Pair[] pairArray = new Pair[1];
        String string = Constant.Companion.getBotToken();
        Intrinsics.checkNotNull((Object)string);
        pairArray[0] = TuplesKt.to((Object)"Authorization", (Object)string);
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    public final boolean mute(long timestamp) {
        String string = Constant.Companion.getThreadLocal().get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"threadLocal.get()");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)this.memberMute, (String)"{{guild_id}}", (String)string, (boolean)false, (int)4, null), (String)"{{user_id}}", (String)this.getId(), (boolean)false, (int)4, null);
        String json = "{\"mute_end_timestamp\": " + timestamp + "}";
        Response res = OkHttpUtils.INSTANCE.patch(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(String.valueOf(res.code()));
        return res.code() == 204;
    }

    public final boolean mute(int seconds) {
        String guildId = Constant.Companion.getThreadLocal().get();
        Intrinsics.checkNotNullExpressionValue((Object)guildId, (String)"guildId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)this.memberMute, (String)"{{guild_id}}", (String)guildId, (boolean)false, (int)4, null), (String)"{{user_id}}", (String)this.getId(), (boolean)false, (int)4, null);
        String json = "{\"mute_seconds\": " + seconds + "}";
        Response res = OkHttpUtils.INSTANCE.patch(url, OkHttpUtils.INSTANCE.addJson(json), this.officeApiHeader());
        Constant.Companion.getLogger().debug(String.valueOf(res.code()));
        return res.code() == 204;
    }
}

