/*
 * Decompiled with CFR 0.152.
 */
package com.hcyacg.protocol.common;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hcyacg.protocol.constant.Constant;
import com.hcyacg.protocol.entity.Announces;
import com.hcyacg.protocol.entity.Channel;
import com.hcyacg.protocol.entity.ChannelDto;
import com.hcyacg.protocol.entity.ChannelPermissions;
import com.hcyacg.protocol.entity.Filter;
import com.hcyacg.protocol.entity.Guild;
import com.hcyacg.protocol.entity.Info;
import com.hcyacg.protocol.entity.Member;
import com.hcyacg.protocol.entity.Message;
import com.hcyacg.protocol.entity.RoleDto;
import com.hcyacg.protocol.entity.RoleVo;
import com.hcyacg.protocol.entity.Roles;
import com.hcyacg.protocol.entity.Schedule;
import com.hcyacg.protocol.entity.User;
import com.hcyacg.protocol.utils.OkHttpUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 H\u0007J \u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\"H\u0007J \u0010%\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\"H\u0007J(\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0007J \u0010.\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020/H\u0007J\u0018\u00102\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0018\u00103\u001a\u0002042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0004H\u0007J(\u00106\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0007J \u00107\u001a\u0002042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0004H\u0007J \u00108\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0007J \u00109\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0007J\u0018\u0010:\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u00101\u001a\u00020/H\u0007J\u0010\u0010;\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u0004H\u0007J\u0018\u0010\n\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0004H\u0007J(\u0010<\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0007J\u0018\u0010=\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0004H\u0007J\u0018\u0010>\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0007J \u0010?\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0007J\u0018\u0010@\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0007J\u0018\u0010A\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0004H\u0007J\u0010\u0010B\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0004H\u0007J\u0018\u0010C\u001a\u00020D2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0007J\u0018\u0010E\u001a\u00020D2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0007J\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020\u001d0G2\u0006\u0010)\u001a\u00020\u0004H\u0007J\u0010\u0010H\u001a\u00020I2\u0006\u0010)\u001a\u00020\u0004H\u0007J&\u0010J\u001a\b\u0012\u0004\u0012\u00020K0G2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010L\u001a\u00020MH\u0007J\b\u0010N\u001a\u00020OH\u0007J\u001e\u0010P\u001a\b\u0012\u0004\u0012\u00020I0G2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010L\u001a\u00020MH\u0007J\u001e\u0010Q\u001a\b\u0012\u0004\u0012\u00020I0G2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010L\u001a\u00020MH\u0007J\u0018\u0010R\u001a\u00020K2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0007J\u0018\u0010S\u001a\u00020T2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0004H\u0007J\u0010\u0010U\u001a\u00020V2\u0006\u0010)\u001a\u00020\u0004H\u0007J\u0018\u0010W\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0004H\u0007J\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020/0G2\u0006\u0010\u001e\u001a\u00020\u0004H\u0007J\u001e\u0010Y\u001a\b\u0012\u0004\u0012\u00020/0G2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010Z\u001a\u00020[H\u0007J\u0014\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040]H\u0002J\u0018\u0010\u0014\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/hcyacg/protocol/common/BotApi;", "", "()V", "changeRole", "", "channel", "channelAnnounces", "channelList", "channelPermissions", "channelRolePermissions", "deleteChannelAnnounces", "deleteGuildAnnounce", "editMemberRole", "getMessage", "guildAnnounce", "guildInfo", "memberInfo", "memberList", "memberMute", "mute", "recall", "roles", "scheduleUrl", "schedules", "sendAudio", "sendMessage", "userMe", "userMeGuild", "changeChannelInfo", "Lcom/hcyacg/protocol/entity/Channel;", "channelId", "channelDto", "Lcom/hcyacg/protocol/entity/ChannelDto;", "changeChannelPermissions", "", "userId", "isAdd", "changeChannelRolePermissions", "roleId", "changeRolesByGuild", "Lcom/hcyacg/protocol/entity/RoleVo;", "guildId", "filter", "Lcom/hcyacg/protocol/entity/Filter;", "info", "Lcom/hcyacg/protocol/entity/Info;", "changeScheduleById", "Lcom/hcyacg/protocol/entity/Schedule;", "scheduleId", "schedule", "createChannel", "createChannelAnnounces", "Lcom/hcyacg/protocol/entity/Announces;", "messageId", "createChildMemberRolesByGuild", "createGuildAnnounces", "createMemberRolesByGuild", "createRolesByGuild", "createSchedule", "deleteChannel", "deleteChildMemberRolesByGuild", "deleteGuildAnnounces", "deleteMember", "deleteMemberRolesByGuild", "deleteRolesByGuild", "deleteScheduleById", "getChannelInfo", "getChannelPermissions", "Lcom/hcyacg/protocol/entity/ChannelPermissions;", "getChannelRolePermissions", "getChildChannelInfo", "", "getGuildById", "Lcom/hcyacg/protocol/entity/Guild;", "getGuildMemberList", "Lcom/hcyacg/protocol/entity/Member;", "limit", "", "getMe", "Lcom/hcyacg/protocol/entity/User;", "getMeGuildsAfter", "getMeGuildsBefore", "getMemberInfo", "getMessageById", "Lcom/hcyacg/protocol/entity/Message;", "getRolesByGuild", "Lcom/hcyacg/protocol/entity/Roles;", "getScheduleById", "getScheduleList", "getScheduleListByTime", "since", "", "officeApiHeader", "", "tencent-guild-protocol"})
public final class BotApi {
    @NotNull
    public static final BotApi INSTANCE = new BotApi();
    @NotNull
    private static final String userMe = "https://api.sgroup.qq.com/users/@me";
    @NotNull
    private static final String userMeGuild = "https://api.sgroup.qq.com/users/@me/guilds";
    @NotNull
    private static final String channel = "https://api.sgroup.qq.com/channels/{{channel_id}}";
    @NotNull
    private static final String channelPermissions = "https://api.sgroup.qq.com/channels/{{channel_id}}/members/{{user_id}}/permissions";
    @NotNull
    private static final String sendMessage = "https://api.sgroup.qq.com/channels/{{channel_id}}/messages";
    @NotNull
    private static final String getMessage = "https://api.sgroup.qq.com/channels/{{channel_id}}/messages/{{message_id}}";
    @NotNull
    private static final String sendAudio = "https://api.sgroup.qq.com/channels/{{channel_id}}/audio";
    @NotNull
    private static final String recall = "https://api.sgroup.qq.com/channels/{{channel_id}}/messages/{{message_id}}";
    @NotNull
    private static final String channelRolePermissions = "https://api.sgroup.qq.com/channels/{{channel_id}}/roles/{{role_id}}/permissions";
    @NotNull
    private static final String guildInfo = "https://api.sgroup.qq.com/guilds/{{guild_id}}";
    @NotNull
    private static final String channelList = "https://api.sgroup.qq.com/guilds/{{guild_id}}/channels";
    @NotNull
    private static final String memberInfo = "https://api.sgroup.qq.com/guilds/{{guild_id}}/members/{{user_id}}";
    @NotNull
    private static final String memberMute = "https://api.sgroup.qq.com/guilds/{{guild_id}}/members/{{user_id}}/mute";
    @NotNull
    private static final String memberList = "https://api.sgroup.qq.com/guilds/{{guild_id}}/members";
    @NotNull
    private static final String roles = "https://api.sgroup.qq.com/guilds/{{guild_id}}/roles";
    @NotNull
    private static final String changeRole = "https://api.sgroup.qq.com/guilds/{{guild_id}}/roles/{{role_id}}";
    @NotNull
    private static final String editMemberRole = "https://api.sgroup.qq.com/guilds/{{guild_id}}/members/{{user_id}}/roles/{{role_id}}";
    @NotNull
    private static final String guildAnnounce = "https://api.sgroup.qq.com/guilds/{{guild_id}}/announces";
    @NotNull
    private static final String deleteGuildAnnounce = "https://api.sgroup.qq.com/guilds/{{guild_id}}/announces/{{message_id}}";
    @NotNull
    private static final String channelAnnounces = "https://api.sgroup.qq.com/channels/{{channel_id}}/announces";
    @NotNull
    private static final String deleteChannelAnnounces = "https://api.sgroup.qq.com/channels/{{channel_id}}/announces/{{message_id}}";
    @NotNull
    private static final String schedules = "https://api.sgroup.qq.com/channels/{{channel_id}}/schedules";
    @NotNull
    private static final String scheduleUrl = "https://api.sgroup.qq.com/channels/{{channel_id}}/schedules/{{schedule_id}}";
    @NotNull
    private static final String mute = "https://api.sgroup.qq.com/guilds/{{guild_id}}/mute";

    private BotApi() {
    }

    private final Map<String, String> officeApiHeader() {
        Pair[] pairArray = new Pair[1];
        String string = Constant.Companion.getBotToken();
        Intrinsics.checkNotNull((Object)string);
        pairArray[0] = TuplesKt.to((Object)"Authorization", (Object)string);
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @JvmStatic
    @NotNull
    public static final Guild getGuildById(@NotNull String guildId) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        String url = StringsKt.replace$default((String)guildInfo, (String)"{{guild_id}}", (String)guildId, (boolean)false, (int)4, null);
        Response res = OkHttpUtils.INSTANCE.get(url, INSTANCE.officeApiHeader());
        ResponseBody responseBody = res.body();
        String result = responseBody == null ? null : responseBody.string();
        Constant.Companion.getLogger().debug(result);
        Object object = new Gson().fromJson(result, Guild.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(result, Guild::class.java)");
        return (Guild)object;
    }

    @JvmStatic
    @NotNull
    public static final Roles getRolesByGuild(@NotNull String guildId) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        String url = StringsKt.replace$default((String)roles, (String)"{{guild_id}}", (String)guildId, (boolean)false, (int)4, null);
        String res = OkHttpUtils.INSTANCE.getJson(url, INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Roles.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Roles::class.java)");
        return (Roles)object;
    }

    @JvmStatic
    @NotNull
    public static final RoleVo createRolesByGuild(@NotNull String guildId, @NotNull Filter filter, @NotNull Info info) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        String url = StringsKt.replace$default((String)roles, (String)"{{guild_id}}", (String)guildId, (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new RoleDto(filter, info));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, RoleVo.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, RoleVo::class.java)");
        return (RoleVo)object;
    }

    @JvmStatic
    @NotNull
    public static final RoleVo changeRolesByGuild(@NotNull String guildId, @NotNull String roleId, @NotNull Filter filter, @NotNull Info info) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        Intrinsics.checkNotNullParameter((Object)roleId, (String)"roleId");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)changeRole, (String)"{{guild_id}}", (String)guildId, (boolean)false, (int)4, null), (String)"{{role_id}}", (String)roleId, (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)new RoleDto(filter, info));
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.patchJson(url, OkHttpUtils.INSTANCE.addJson(json), INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, RoleVo.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, RoleVo::class.java)");
        return (RoleVo)object;
    }

    @JvmStatic
    public static final boolean deleteRolesByGuild(@NotNull String guildId, @NotNull String roleId) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        Intrinsics.checkNotNullParameter((Object)roleId, (String)"roleId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)changeRole, (String)"{{guild_id}}", (String)guildId, (boolean)false, (int)4, null), (String)"{{role_id}}", (String)roleId, (boolean)false, (int)4, null);
        Response res = OkHttpUtils.INSTANCE.delete(url, (Map<String, String>)new LinkedHashMap(), INSTANCE.officeApiHeader());
        Logger logger = Constant.Companion.getLogger();
        ResponseBody responseBody = res.body();
        Intrinsics.checkNotNull((Object)responseBody);
        logger.debug(responseBody.string());
        return res.code() == 204;
    }

    @JvmStatic
    public static final boolean createMemberRolesByGuild(@NotNull String guildId, @NotNull String userId, @NotNull String roleId) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)roleId, (String)"roleId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)editMemberRole, (String)"{{guild_id}}", (String)guildId, (boolean)false, (int)4, null), (String)"{{user_id}}", (String)userId, (boolean)false, (int)4, null), (String)"{{role_id}}", (String)roleId, (boolean)false, (int)4, null);
        Response res = OkHttpUtils.INSTANCE.put(url, (Map<String, String>)new LinkedHashMap(), INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(String.valueOf(res.code()));
        return res.code() == 204;
    }

    @JvmStatic
    public static final boolean createChildMemberRolesByGuild(@NotNull String guildId, @NotNull Channel channel, @NotNull String userId, @NotNull String roleId) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)roleId, (String)"roleId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)editMemberRole, (String)"{{guild_id}}", (String)guildId, (boolean)false, (int)4, null), (String)"{{user_id}}", (String)userId, (boolean)false, (int)4, null), (String)"{{role_id}}", (String)roleId, (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)channel);
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        RequestBody requestBody = OkHttpUtils.INSTANCE.addJson(json);
        String[] stringArray = new String[2];
        stringArray[0] = "Authorization";
        Intrinsics.checkNotNull((Object)Constant.Companion.getBotToken());
        Response res = OkHttpUtils.INSTANCE.put(url, requestBody, Headers.Companion.of(stringArray));
        Constant.Companion.getLogger().debug(String.valueOf(res.code()));
        return res.code() == 204;
    }

    @JvmStatic
    public static final boolean deleteMemberRolesByGuild(@NotNull String guildId, @NotNull String userId, @NotNull String roleId) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)roleId, (String)"roleId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)editMemberRole, (String)"{{guild_id}}", (String)guildId, (boolean)false, (int)4, null), (String)"{{user_id}}", (String)userId, (boolean)false, (int)4, null), (String)"{{role_id}}", (String)roleId, (boolean)false, (int)4, null);
        Response res = OkHttpUtils.INSTANCE.delete(url, (Map<String, String>)new LinkedHashMap(), INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(String.valueOf(res.code()));
        return res.code() == 204;
    }

    @JvmStatic
    public static final boolean deleteChildMemberRolesByGuild(@NotNull String guildId, @NotNull Channel channel, @NotNull String userId, @NotNull String roleId) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)roleId, (String)"roleId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)editMemberRole, (String)"{{guild_id}}", (String)guildId, (boolean)false, (int)4, null), (String)"{{user_id}}", (String)userId, (boolean)false, (int)4, null), (String)"{{role_id}}", (String)roleId, (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)channel);
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        Response res = OkHttpUtils.INSTANCE.delete(url, OkHttpUtils.INSTANCE.addJson(json), INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(String.valueOf(res.code()));
        return res.code() == 204;
    }

    @JvmStatic
    @NotNull
    public static final Member getMemberInfo(@NotNull String guildId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)memberInfo, (String)"{{guild_id}}", (String)guildId, (boolean)false, (int)4, null), (String)"{{user_id}}", (String)userId, (boolean)false, (int)4, null);
        String res = OkHttpUtils.INSTANCE.getJson(url, INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Member.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Member::class.java)");
        return (Member)object;
    }

    @JvmStatic
    @NotNull
    public static final Channel getChannelInfo(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        String url = StringsKt.replace$default((String)channel, (String)"{{channel_id}}", (String)channelId, (boolean)false, (int)4, null);
        String res = OkHttpUtils.INSTANCE.getJson(url, INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Channel.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Channel::class.java)");
        return (Channel)object;
    }

    @JvmStatic
    @NotNull
    public static final List<Channel> getChildChannelInfo(@NotNull String guildId) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        String url = StringsKt.replace$default((String)channelList, (String)"{{guild_id}}", (String)guildId, (boolean)false, (int)4, null);
        String res = OkHttpUtils.INSTANCE.getJson(url, INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, new TypeToken<List<? extends Channel>>(){}.getType());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, obj\u2026List<Channel>>() {}.type)");
        return (List)object;
    }

    @JvmStatic
    @NotNull
    public static final Message getMessageById(@NotNull String channelId, @NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)"https://api.sgroup.qq.com/channels/{{channel_id}}/messages/{{message_id}}", (String)"{{channel_id}}", (String)channelId, (boolean)false, (int)4, null), (String)"{{message_id}}", (String)messageId, (boolean)false, (int)4, null);
        String res = OkHttpUtils.INSTANCE.getJson(url, INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Message.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Message::class.java)");
        return (Message)object;
    }

    @JvmStatic
    @NotNull
    public static final ChannelPermissions getChannelPermissions(@NotNull String channelId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)channelPermissions, (String)"{{channel_id}}", (String)channelId, (boolean)false, (int)4, null), (String)"{{user_id}}", (String)userId, (boolean)false, (int)4, null);
        String res = OkHttpUtils.INSTANCE.getJson(url, INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, ChannelPermissions.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Cha\u2026lPermissions::class.java)");
        return (ChannelPermissions)object;
    }

    @JvmStatic
    public static final boolean changeChannelPermissions(@NotNull String channelId, @NotNull String userId, boolean isAdd) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)channelPermissions, (String)"{{channel_id}}", (String)channelId, (boolean)false, (int)4, null), (String)"{{user_id}}", (String)userId, (boolean)false, (int)4, null);
        Map map = new LinkedHashMap();
        if (isAdd) {
            map.put("add", "0");
        } else {
            map.put("remove", "2");
        }
        Response res = OkHttpUtils.INSTANCE.put(url, (Map<String, String>)map, INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(String.valueOf(res.code()));
        return res.code() == 204;
    }

    @JvmStatic
    @NotNull
    public static final ChannelPermissions getChannelRolePermissions(@NotNull String channelId, @NotNull String roleId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)roleId, (String)"roleId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)channelRolePermissions, (String)"{{channel_id}}", (String)channelId, (boolean)false, (int)4, null), (String)"{{role_id}}", (String)roleId, (boolean)false, (int)4, null);
        String res = OkHttpUtils.INSTANCE.getJson(url, INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, ChannelPermissions.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Cha\u2026lPermissions::class.java)");
        return (ChannelPermissions)object;
    }

    @JvmStatic
    public static final boolean changeChannelRolePermissions(@NotNull String channelId, @NotNull String roleId, boolean isAdd) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)roleId, (String)"roleId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)channelRolePermissions, (String)"{{channel_id}}", (String)channelId, (boolean)false, (int)4, null), (String)"{{role_id}}", (String)roleId, (boolean)false, (int)4, null);
        Map map = new LinkedHashMap();
        if (isAdd) {
            map.put("add", "0");
        } else {
            map.put("remove", "2");
        }
        Response res = OkHttpUtils.INSTANCE.put(url, (Map<String, String>)map, INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(String.valueOf(res.code()));
        return res.code() == 204;
    }

    @JvmStatic
    @NotNull
    public static final User getMe() {
        String res = OkHttpUtils.INSTANCE.getJson(userMe, INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        User user = (User)new Gson().fromJson(res, User.class);
        user.setBot(true);
        Intrinsics.checkNotNullExpressionValue((Object)user, (String)"user");
        return user;
    }

    @JvmStatic
    @NotNull
    public static final List<Guild> getMeGuildsBefore(@NotNull String guildId, int limit) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        String url = userMeGuild + "?before=" + guildId + "&limit=" + limit;
        String res = OkHttpUtils.INSTANCE.getJson(url, INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, new TypeToken<List<? extends Guild>>(){}.getType());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, obj\u2026n<List<Guild>>() {}.type)");
        return (List)object;
    }

    @JvmStatic
    @NotNull
    public static final List<Guild> getMeGuildsAfter(@NotNull String guildId, int limit) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        String url = userMeGuild + "?after=" + guildId + "&limit=" + limit;
        String res = OkHttpUtils.INSTANCE.getJson(url, INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, new TypeToken<List<? extends Guild>>(){}.getType());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, obj\u2026n<List<Guild>>() {}.type)");
        return (List)object;
    }

    @JvmStatic
    @NotNull
    public static final List<Member> getGuildMemberList(@NotNull String guildId, @NotNull String userId, int limit) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        String url = StringsKt.replace$default((String)memberList, (String)"{{guild_id}}", (String)guildId, (boolean)false, (int)4, null);
        String cfr_ignored_0 = url + "?after=" + userId + "&limit=" + limit;
        Object object = new String[2];
        object[0] = "Authorization";
        Intrinsics.checkNotNull((Object)Constant.Companion.getBotToken());
        String res = OkHttpUtils.INSTANCE.getJson(url, Headers.Companion.of(object));
        Constant.Companion.getLogger().debug(res);
        object = new Gson().fromJson(res, new TypeToken<List<? extends Member>>(){}.getType());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, obj\u2026<List<Member>>() {}.type)");
        return (List)object;
    }

    @JvmStatic
    public static final boolean deleteMember(@NotNull String guildId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)memberInfo, (String)"{{guild_id}}", (String)guildId, (boolean)false, (int)4, null), (String)"{{user_id}}", (String)userId, (boolean)false, (int)4, null);
        Response res = OkHttpUtils.INSTANCE.delete(url, (Map<String, String>)new LinkedHashMap(), INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(String.valueOf(res.code()));
        return res.code() == 204;
    }

    @JvmStatic
    @NotNull
    public static final Channel createChannel(@NotNull String guildId, @NotNull ChannelDto channelDto) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        Intrinsics.checkNotNullParameter((Object)channelDto, (String)"channelDto");
        String url = StringsKt.replace$default((String)channelList, (String)"{{guild_id}}", (String)guildId, (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)channelDto);
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Channel.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Channel::class.java)");
        return (Channel)object;
    }

    @JvmStatic
    @NotNull
    public static final Channel changeChannelInfo(@NotNull String channelId, @NotNull ChannelDto channelDto) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)channelDto, (String)"channelDto");
        String url = StringsKt.replace$default((String)channel, (String)"{{channel_id}}", (String)channelId, (boolean)false, (int)4, null);
        String json = new Gson().toJson((Object)channelDto);
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        String res = OkHttpUtils.INSTANCE.patchJson(url, OkHttpUtils.INSTANCE.addJson(json), INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Channel.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Channel::class.java)");
        return (Channel)object;
    }

    @JvmStatic
    public static final boolean deleteChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        String url = StringsKt.replace$default((String)channel, (String)"{{channel_id}}", (String)channelId, (boolean)false, (int)4, null);
        Response res = OkHttpUtils.INSTANCE.delete(url, (Map<String, String>)new LinkedHashMap(), INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(String.valueOf(res.code()));
        return res.code() == 200;
    }

    @JvmStatic
    @NotNull
    public static final Announces createGuildAnnounces(@NotNull String guildId, @NotNull String channelId, @NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        String url = StringsKt.replace$default((String)guildAnnounce, (String)"{{guild_id}}", (String)guildId, (boolean)false, (int)4, null);
        String json = "{\"message_id\": \"" + messageId + "\",\"channel_id\":\"" + channelId + "\"}";
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Announces.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Announces::class.java)");
        return (Announces)object;
    }

    @JvmStatic
    public static final boolean deleteGuildAnnounces(@NotNull String guildId, @NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)guildId, (String)"guildId");
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)deleteGuildAnnounce, (String)"{{guild_id}}", (String)guildId, (boolean)false, (int)4, null), (String)"{{message_id}}", (String)messageId, (boolean)false, (int)4, null);
        Response res = OkHttpUtils.INSTANCE.delete(url, (Map<String, String>)new LinkedHashMap(), INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(String.valueOf(res.code()));
        return res.code() == 204;
    }

    @JvmStatic
    @NotNull
    public static final Announces createChannelAnnounces(@NotNull String channelId, @NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        String url = StringsKt.replace$default((String)channelAnnounces, (String)"{{channel_id}}", (String)channelId, (boolean)false, (int)4, null);
        String json = "{\"message_id\": \"" + messageId + "\"}";
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Announces.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Announces::class.java)");
        return (Announces)object;
    }

    @JvmStatic
    public static final boolean deleteChannelAnnounces(@NotNull String channelId, @NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)deleteChannelAnnounces, (String)"{{channel_id}}", (String)channelId, (boolean)false, (int)4, null), (String)"{{message_id}}", (String)messageId, (boolean)false, (int)4, null);
        Response res = OkHttpUtils.INSTANCE.delete(url, (Map<String, String>)new LinkedHashMap(), INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(String.valueOf(res.code()));
        return res.code() == 204;
    }

    @JvmStatic
    @NotNull
    public static final List<Schedule> getScheduleListByTime(@NotNull String channelId, long since) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        String url = StringsKt.replace$default((String)schedules, (String)"{{channel_id}}", (String)channelId, (boolean)false, (int)4, null);
        String cfr_ignored_0 = url + "?since=" + since;
        Object object = new String[2];
        object[0] = "Authorization";
        Intrinsics.checkNotNull((Object)Constant.Companion.getBotToken());
        String res = OkHttpUtils.INSTANCE.getJson(url, Headers.Companion.of(object));
        Constant.Companion.getLogger().debug(res);
        if (res.contentEquals("null")) {
            return new ArrayList();
        }
        object = new Gson().fromJson(res, new TypeToken<List<? extends Schedule>>(){}.getType());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, obj\u2026ist<Schedule>>() {}.type)");
        return (List)object;
    }

    @JvmStatic
    @NotNull
    public static final List<Schedule> getScheduleList(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        String url = StringsKt.replace$default((String)schedules, (String)"{{channel_id}}", (String)channelId, (boolean)false, (int)4, null);
        Object object = new String[2];
        object[0] = "Authorization";
        Intrinsics.checkNotNull((Object)Constant.Companion.getBotToken());
        String res = OkHttpUtils.INSTANCE.getJson(url, Headers.Companion.of(object));
        Constant.Companion.getLogger().debug(res);
        if (res.contentEquals("null")) {
            return new ArrayList();
        }
        object = new Gson().fromJson(res, new TypeToken<List<? extends Schedule>>(){}.getType());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, obj\u2026ist<Schedule>>() {}.type)");
        return (List)object;
    }

    @JvmStatic
    @NotNull
    public static final Schedule getScheduleById(@NotNull String channelId, @NotNull String scheduleId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)scheduleId, (String)"scheduleId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)scheduleUrl, (String)"{{channel_id}}", (String)channelId, (boolean)false, (int)4, null), (String)"{{schedule_id}}", (String)scheduleId, (boolean)false, (int)4, null);
        Object object = new String[2];
        object[0] = "Authorization";
        Intrinsics.checkNotNull((Object)Constant.Companion.getBotToken());
        String res = OkHttpUtils.INSTANCE.getJson(url, Headers.Companion.of(object));
        Constant.Companion.getLogger().debug(res);
        object = new Gson().fromJson(res, Schedule.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Schedule::class.java)");
        return (Schedule)object;
    }

    @JvmStatic
    @NotNull
    public static final Schedule createSchedule(@NotNull String channelId, @NotNull Schedule schedule) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)schedule, (String)"schedule");
        String url = StringsKt.replace$default((String)schedules, (String)"{{channel_id}}", (String)channelId, (boolean)false, (int)4, null);
        schedule.setCreator(null);
        String json = "{\"schedule\": " + new Gson().toJson((Object)schedule) + "}";
        String res = OkHttpUtils.INSTANCE.postJson(url, OkHttpUtils.INSTANCE.addJson(json), INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Schedule.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Schedule::class.java)");
        return (Schedule)object;
    }

    @JvmStatic
    @NotNull
    public static final Schedule changeScheduleById(@NotNull String channelId, @NotNull String scheduleId, @NotNull Schedule schedule) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)scheduleId, (String)"scheduleId");
        Intrinsics.checkNotNullParameter((Object)schedule, (String)"schedule");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)scheduleUrl, (String)"{{channel_id}}", (String)channelId, (boolean)false, (int)4, null), (String)"{{schedule_id}}", (String)scheduleId, (boolean)false, (int)4, null);
        schedule.setCreator(null);
        String json = "{\"schedule\": " + new Gson().toJson((Object)schedule) + "}";
        String res = OkHttpUtils.INSTANCE.patchJson(url, OkHttpUtils.INSTANCE.addJson(json), INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(res);
        Object object = new Gson().fromJson(res, Schedule.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(res, Schedule::class.java)");
        return (Schedule)object;
    }

    @JvmStatic
    public static final boolean deleteScheduleById(@NotNull String channelId, @NotNull String scheduleId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)scheduleId, (String)"scheduleId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)scheduleUrl, (String)"{{channel_id}}", (String)channelId, (boolean)false, (int)4, null), (String)"{{schedule_id}}", (String)scheduleId, (boolean)false, (int)4, null);
        Response res = OkHttpUtils.INSTANCE.delete(url, (Map<String, String>)new LinkedHashMap(), INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(String.valueOf(res.code()));
        return res.code() == 204;
    }

    @JvmStatic
    public static final boolean recall(@NotNull String channelId, @NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        String url = StringsKt.replace$default((String)StringsKt.replace$default((String)"https://api.sgroup.qq.com/channels/{{channel_id}}/messages/{{message_id}}", (String)"{{channel_id}}", (String)channelId, (boolean)false, (int)4, null), (String)"{{message_id}}", (String)messageId, (boolean)false, (int)4, null);
        Response res = OkHttpUtils.INSTANCE.delete(url, (Map<String, String>)new LinkedHashMap(), INSTANCE.officeApiHeader());
        Constant.Companion.getLogger().debug(String.valueOf(res.code()));
        return res.code() == 200;
    }
}

