/*
 * Decompiled with CFR 0.152.
 */
package proguard.gradle.plugin.android;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.api.variant.VariantInfo;
import com.android.build.gradle.BaseExtension;
import com.android.builder.core.LibraryRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.gradle.ProGuardTask;
import proguard.gradle.plugin.android.AndroidPluginKt;
import proguard.gradle.plugin.android.AndroidProjectType;
import proguard.gradle.plugin.android.dsl.ProGuardAndroidExtension;
import proguard.gradle.plugin.android.dsl.ProGuardConfiguration;
import proguard.gradle.plugin.android.dsl.UserProGuardConfiguration;
import proguard.gradle.plugin.android.dsl.VariantConfiguration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0010\u0010\u0015\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00170\u0016H\u0016J\u0010\u0010\u0018\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00170\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016J4\u0010!\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%0$j\u0002`#0\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020*H\u0002J\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020%0\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J\u0019\u0010,\u001a\u0013\u0018\u00010\u0011\u00a2\u0006\f\b-\u0012\b\b.\u0012\u0004\b\b(/H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lproguard/gradle/plugin/android/ProGuardTransform;", "Lcom/android/build/api/transform/Transform;", "project", "Lorg/gradle/api/Project;", "proguardBlock", "Lproguard/gradle/plugin/android/dsl/ProGuardAndroidExtension;", "projectType", "Lproguard/gradle/plugin/android/AndroidProjectType;", "androidExtension", "Lcom/android/build/gradle/BaseExtension;", "<init>", "(Lorg/gradle/api/Project;Lproguard/gradle/plugin/android/dsl/ProGuardAndroidExtension;Lproguard/gradle/plugin/android/AndroidProjectType;Lcom/android/build/gradle/BaseExtension;)V", "transform", "", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "getName", "", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$DefaultContentType;", "getScopes", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "getReferencedScopes", "isIncremental", "", "applyToVariant", "variant", "Lcom/android/build/api/variant/VariantInfo;", "getSecondaryFiles", "", "Lcom/android/build/api/transform/SecondaryFile;", "createIOEntries", "", "Lproguard/gradle/plugin/android/ProGuardIOEntry;", "Lkotlin/Pair;", "Ljava/io/File;", "inputs", "", "Lcom/android/build/api/transform/TransformInput;", "outputProvider", "Lcom/android/build/api/transform/TransformOutputProvider;", "createLibraryJars", "getAaptRulesFile", "Lkotlin/ParameterName;", "name", "b", "gradle"})
@SourceDebugExtension(value={"SMAP\nProGuardTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProGuardTransform.kt\nproguard/gradle/plugin/android/ProGuardTransform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1855#2,2:160\n1549#2:162\n1620#2,3:163\n1360#2:167\n1446#2,5:168\n800#2,11:173\n1549#2:184\n1620#2,3:185\n1360#2:188\n1446#2,2:189\n1549#2:191\n1620#2,3:192\n1448#2,3:195\n1360#2:198\n1446#2,2:199\n1549#2:201\n1620#2,3:202\n1448#2,3:205\n1549#2:208\n1620#2,3:209\n3464#2,10:212\n288#2,2:222\n1#3:166\n*S KotlinDebug\n*F\n+ 1 ProGuardTransform.kt\nproguard/gradle/plugin/android/ProGuardTransform\n*L\n65#1:160,2\n77#1:162\n77#1:163,3\n120#1:167\n120#1:168,5\n121#1:173,11\n122#1:184\n122#1:185,3\n138#1:188\n138#1:189,2\n139#1:191\n139#1:192,3\n138#1:195,3\n144#1:198\n144#1:199,2\n144#1:201\n144#1:202,3\n144#1:205,3\n148#1:208\n148#1:209,3\n153#1:212,10\n155#1:222,2\n*E\n"})
public final class ProGuardTransform
extends Transform {
    @NotNull
    private final Project project;
    @NotNull
    private final ProGuardAndroidExtension proguardBlock;
    @NotNull
    private final AndroidProjectType projectType;
    @NotNull
    private final BaseExtension androidExtension;

    public ProGuardTransform(@NotNull Project project, @NotNull ProGuardAndroidExtension proguardBlock, @NotNull AndroidProjectType projectType, @NotNull BaseExtension androidExtension) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)proguardBlock, (String)"proguardBlock");
        Intrinsics.checkNotNullParameter((Object)((Object)projectType), (String)"projectType");
        Intrinsics.checkNotNullParameter((Object)androidExtension, (String)"androidExtension");
        this.project = project;
        this.proguardBlock = proguardBlock;
        this.projectType = projectType;
        this.androidExtension = androidExtension;
    }

    /*
     * WARNING - void declaration
     */
    public void transform(@NotNull TransformInvocation transformInvocation) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)transformInvocation, (String)"transformInvocation");
        String string = transformInvocation.getContext().getVariantName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVariantName(...)");
        String variantName = string;
        VariantConfiguration variantConfiguration = AndroidPluginKt.findVariantConfiguration((Iterable<VariantConfiguration>)((Iterable)this.proguardBlock.getConfigurations()), variantName);
        if (variantConfiguration == null) {
            throw new RuntimeException("Invalid configuration: " + variantName);
        }
        VariantConfiguration variantBlock = variantConfiguration;
        ProGuardTask proguardTask = (ProGuardTask)this.project.getTasks().create("proguardTask" + StringsKt.capitalize((String)variantName), ProGuardTask.class);
        Collection collection = transformInvocation.getInputs();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getInputs(...)");
        TransformOutputProvider transformOutputProvider = transformInvocation.getOutputProvider();
        Intrinsics.checkNotNullExpressionValue((Object)transformOutputProvider, (String)"getOutputProvider(...)");
        Object $this$forEach$iv = (Object[])this.createIOEntries(collection, transformOutputProvider);
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            Pair it = (Pair)t;
            boolean bl = false;
            proguardTask.injars(it.getFirst());
            proguardTask.outjars(it.getSecond());
        }
        $this$forEach$iv = new QualifiedContent.DefaultContentType[]{QualifiedContent.DefaultContentType.CLASSES, QualifiedContent.DefaultContentType.RESOURCES};
        Set set = SetsKt.setOf((Object[])$this$forEach$iv);
        $this$forEach$iv = new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT};
        proguardTask.extraJar(transformInvocation.getOutputProvider().getContentLocation("extra.jar", set, SetsKt.mutableSetOf((Object[])$this$forEach$iv), Format.JAR));
        Collection collection2 = transformInvocation.getReferencedInputs();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getReferencedInputs(...)");
        proguardTask.libraryjars(this.createLibraryJars(collection2));
        proguardTask.configuration(this.project.getTasks().getByPath("collectConsumerRules" + StringsKt.capitalize((String)variantName)).getOutputs().getFiles());
        $this$forEach$iv = variantBlock.getConfigurations();
        ProGuardTask proGuardTask = proguardTask;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProGuardConfiguration proGuardConfiguration = (ProGuardConfiguration)item$iv$iv;
            Collection collection4 = collection3;
            boolean bl = false;
            collection4.add(this.project.file((Object)it.getPath()));
        }
        proGuardTask.configuration((List)collection3);
        String aaptRulesFile = this.getAaptRulesFile();
        if (aaptRulesFile != null && new File(aaptRulesFile).exists()) {
            proguardTask.configuration(aaptRulesFile);
        } else {
            this.project.getLogger().warn("AAPT rules file not found: you may need to apply some extra keep rules for classes referenced from resources in your own ProGuard configuration.");
        }
        File file = this.project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getBuildDir(...)");
        File mappingDir = FilesKt.resolve((File)file, (String)("outputs/proguard/" + variantName + "/mapping"));
        if (!mappingDir.exists()) {
            mappingDir.mkdirs();
        }
        proguardTask.printmapping(new File(mappingDir, "mapping.txt"));
        proguardTask.printseeds(new File(mappingDir, "seeds.txt"));
        proguardTask.printusage(new File(mappingDir, "usage.txt"));
        proguardTask.android();
        proguardTask.proguard();
    }

    @NotNull
    public String getName() {
        return "ProguardTransform";
    }

    @NotNull
    public Set<QualifiedContent.DefaultContentType> getInputTypes() {
        Object[] objectArray = new QualifiedContent.DefaultContentType[]{QualifiedContent.DefaultContentType.CLASSES, QualifiedContent.DefaultContentType.RESOURCES};
        return SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        Set set;
        switch (WhenMappings.$EnumSwitchMapping$0[this.projectType.ordinal()]) {
            case 1: {
                Object[] objectArray = new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT, QualifiedContent.Scope.SUB_PROJECTS, QualifiedContent.Scope.EXTERNAL_LIBRARIES};
                set = SetsKt.mutableSetOf((Object[])objectArray);
                break;
            }
            case 2: {
                Object[] objectArray = new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT};
                set = SetsKt.mutableSetOf((Object[])objectArray);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return set;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        Set set;
        switch (WhenMappings.$EnumSwitchMapping$0[this.projectType.ordinal()]) {
            case 1: {
                Object[] objectArray = new QualifiedContent.Scope[]{QualifiedContent.Scope.PROVIDED_ONLY};
                set = SetsKt.mutableSetOf((Object[])objectArray);
                break;
            }
            case 2: {
                Object[] objectArray = new QualifiedContent.Scope[]{QualifiedContent.Scope.PROVIDED_ONLY, QualifiedContent.Scope.EXTERNAL_LIBRARIES, QualifiedContent.Scope.SUB_PROJECTS};
                set = SetsKt.mutableSetOf((Object[])objectArray);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return set;
    }

    public boolean isIncremental() {
        return false;
    }

    public boolean applyToVariant(@Nullable VariantInfo variant) {
        VariantConfiguration variantConfiguration;
        VariantInfo variantInfo = variant;
        if (variantInfo != null) {
            VariantInfo it = variantInfo;
            boolean bl = false;
            variantConfiguration = AndroidPluginKt.findVariantConfiguration((Iterable<VariantConfiguration>)((Iterable)this.proguardBlock.getConfigurations()), it);
        } else {
            variantConfiguration = null;
        }
        return variantConfiguration != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<SecondaryFile> getSecondaryFiles() {
        Set set;
        block3: {
            void $this$mapTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Object list$iv$iv;
            VariantConfiguration it;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = (Iterable)this.proguardBlock.getConfigurations();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (VariantConfiguration)element$iv$iv;
                boolean bl = false;
                list$iv$iv = it.getConfigurations();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstance = false;
            $this$flatMapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof UserProGuardConfiguration)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (UserProGuardConfiguration)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new SecondaryFile(this.project.file((Object)((ProGuardConfiguration)((Object)it)).getPath()), false));
            }
            Set $this$getSecondaryFiles_u24lambda_u246 = set = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
            boolean bl = false;
            String string = this.getAaptRulesFile();
            if (string == null) break block3;
            String it2 = string;
            boolean bl2 = false;
            $this$getSecondaryFiles_u24lambda_u246.add(new SecondaryFile(this.project.file((Object)it2), false));
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<File, File>> createIOEntries(Collection<? extends TransformInput> inputs, TransformOutputProvider outputProvider) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = inputs;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JarInput it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            TransformInput input = (TransformInput)element$iv$iv;
            boolean bl = false;
            Collection collection2 = input.getDirectoryInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getDirectoryInputs(...)");
            Iterable $this$map$iv = collection2;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DirectoryInput directoryInput = (DirectoryInput)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(ProGuardTransform.createIOEntries$createEntry(outputProvider, (QualifiedContent)it, Format.DIRECTORY));
            }
            Collection collection3 = (List)destination$iv$iv2;
            Collection collection4 = input.getJarInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"getJarInputs(...)");
            $this$map$iv = collection4;
            collection = collection3;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (JarInput)item$iv$iv;
                Collection collection5 = destination$iv$iv2;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                collection5.add(ProGuardTransform.createIOEntries$createEntry(outputProvider, (QualifiedContent)it, Format.JAR));
            }
            Iterable list$iv$iv = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> createLibraryJars(Collection<? extends TransformInput> inputs) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = inputs;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JarInput it;
            Collection collection;
            Iterable $this$mapTo$iv$iv2;
            TransformInput input = (TransformInput)element$iv$iv;
            boolean bl = false;
            Collection collection2 = input.getDirectoryInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getDirectoryInputs(...)");
            Iterable $this$map$iv2 = collection2;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                DirectoryInput directoryInput = (DirectoryInput)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getFile());
            }
            Collection collection3 = (List)destination$iv$iv2;
            Collection collection4 = input.getJarInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"getJarInputs(...)");
            $this$map$iv2 = collection4;
            collection = collection3;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (JarInput)item$iv$iv;
                Collection collection5 = destination$iv$iv2;
                boolean bl3 = false;
                collection5.add(it.getFile());
            }
            list$iv$iv = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = this.androidExtension.getLibraryRequests();
        Collection collection = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)CollectionsKt.listOf((Object)FilesKt.resolve((File)this.androidExtension.getSdkDirectory(), (String)("platforms/" + this.androidExtension.getCompileSdkVersion() + "/android.jar"))));
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            list$iv$iv = (LibraryRequest)item$iv$iv;
            Collection collection6 = destination$iv$iv;
            boolean bl = false;
            collection6.add(FilesKt.resolve((File)this.androidExtension.getSdkDirectory(), (String)("platforms/" + this.androidExtension.getCompileSdkVersion() + "/optional/" + it.getName() + ".jar")));
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final String getAaptRulesFile() {
        Object v1;
        block4: {
            List list;
            Iterable $this$zipWithNext$iv = AndroidPluginKt.getAaptAdditionalParameters(this.androidExtension);
            boolean $i$f$zipWithNext = false;
            Iterator iterator$iv = $this$zipWithNext$iv.iterator();
            if (!iterator$iv.hasNext()) {
                list = CollectionsKt.emptyList();
            } else {
                List result$iv = new ArrayList();
                Object current$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void param;
                    void cmd;
                    Object next$iv = iterator$iv.next();
                    String string = (String)next$iv;
                    String string2 = (String)current$iv;
                    List list2 = result$iv;
                    boolean bl = false;
                    list2.add(Intrinsics.areEqual((Object)cmd, (Object)"--proguard") ? param : null);
                    current$iv = next$iv;
                }
                list = result$iv;
            }
            Iterable $this$firstOrNull$iv = CollectionsKt.filterNotNull((Iterable)list);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!new File(it).exists()) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        return v1;
    }

    private static final Pair<File, File> createIOEntries$createEntry(TransformOutputProvider $outputProvider, QualifiedContent input, Format format) {
        File file = input.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
        File file2 = $outputProvider.getContentLocation(input.getName(), input.getContentTypes(), input.getScopes(), format).getCanonicalFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getCanonicalFile(...)");
        return new Pair((Object)file, (Object)file2);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AndroidProjectType.values().length];
            try {
                nArray[AndroidProjectType.ANDROID_APPLICATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidProjectType.ANDROID_LIBRARY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

