/*
 * Decompiled with CFR 0.152.
 */
package proguard.gradle.plugin;

import com.android.build.gradle.BaseExtension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import proguard.gradle.plugin.android.AndroidPlugin;
import proguard.gradle.plugin.android.AndroidPluginKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lproguard/gradle/plugin/ProGuardPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "<init>", "()V", "apply", "", "project", "gradle"})
public final class ProGuardPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        BaseExtension androidExtension = (BaseExtension)project.getExtensions().findByName("android");
        Object javaExtension = project.getExtensions().findByName("java");
        String javaErrMessage = "For Java projects, you can manually declare a ProGuardTask instead of applying the plugin:\n\n     task myProguardTask(type: proguard.gradle.ProGuardTask) {\n       // ...\n     }";
        if (androidExtension != null) {
            if (AndroidPluginKt.getAgpVersion().getMajorVersion() < 4) {
                throw new GradleException("The ProGuard plugin only supports Android plugin 4 and higher.\nFor Android plugin version 3 and lower, you can use ProGuard through the Android plugin integration.\nPlease refer to the manual for further details: https://www.guardsquare.com/manual/setup/gradleplugin");
            }
        } else {
            if (javaExtension != null) {
                throw new GradleException(StringsKt.trimMargin$default((String)("The ProGuard plugin requires the Android plugin to function properly.\n                           |" + javaErrMessage + "\n                           "), null, (int)1, null));
            }
            throw new GradleException(StringsKt.trimMargin$default((String)("For Android applications or libraries 'com.android.application' or 'com.android.library' is required, respectively. \n                      |" + javaErrMessage + "\n                      "), null, (int)1, null));
        }
        new AndroidPlugin(androidExtension).apply(project);
    }
}

