/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.ProgramMethodOptimizationInfo;

public class FinalFieldAssignmentMarker
implements InstructionVisitor,
ConstantVisitor {
    private Method referencedMethod;

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        if (constantInstruction.opcode == -77 || constantInstruction.opcode == -75) {
            this.referencedMethod = method;
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
        }
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        if (fieldrefConstant.referencedField != null && (fieldrefConstant.referencedField.getAccessFlags() & 0x10) != 0) {
            FinalFieldAssignmentMarker.setAssignsFinalField(this.referencedMethod);
        }
    }

    private static void setAssignsFinalField(Method method) {
        ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(method).setAssignsFinalField();
    }

    public static boolean assignsFinalField(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).assignsFinalField();
    }
}

