/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate.kotlin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.classfile.util.ClassUtil;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.KotlinModule;
import proguard.resources.kotlinmodule.KotlinModulePackage;
import proguard.resources.kotlinmodule.visitor.KotlinModulePackageVisitor;

public class KotlinModuleFixer
implements ResourceFileVisitor {
    public void visitKotlinModule(KotlinModule kotlinModule) {
        kotlinModule.fileName = KotlinModuleFixer.moduleNameToFileName(kotlinModule.name);
        ArrayList<String> existingPackageNames = new ArrayList<String>();
        kotlinModule.modulePackagesAccept((KotlinModulePackageVisitor)new ModulePackageNameFixer(existingPackageNames));
        HashMap<String, KotlinFileFacadeKindMetadata> fileFacadesToMove = new HashMap<String, KotlinFileFacadeKindMetadata>();
        HashMap<String, KotlinMultiFilePartKindMetadata> multiFilePartsToMove = new HashMap<String, KotlinMultiFilePartKindMetadata>();
        kotlinModule.modulePackagesAccept((KotlinModulePackageVisitor)new ToMoveCollector(fileFacadesToMove, multiFilePartsToMove));
        kotlinModule.modulePackagesAccept((KotlinModulePackageVisitor)new ModulePartCleaner(fileFacadesToMove, multiFilePartsToMove));
        KotlinModuleFixer.createNewModulePackages(kotlinModule, existingPackageNames, fileFacadesToMove, multiFilePartsToMove);
        KotlinModuleFixer.addFileFacadesToModule(kotlinModule, fileFacadesToMove);
        KotlinModuleFixer.addMultiFilePartsToModule(kotlinModule, multiFilePartsToMove);
    }

    private static void createNewModulePackages(KotlinModule kotlinModule, List<String> existingPackageNames, Map<String, KotlinFileFacadeKindMetadata> fileFacadesToMove, Map<String, KotlinMultiFilePartKindMetadata> multiFilePartsToMove) {
        Stream.concat(fileFacadesToMove.keySet().stream(), multiFilePartsToMove.keySet().stream()).map(ClassUtil::internalPackageName).distinct().filter(packageName -> !existingPackageNames.contains(packageName)).map(packageName -> new KotlinModulePackage(packageName, new ArrayList(), new HashMap())).forEach(kotlinModule.modulePackages::add);
    }

    private static void addFileFacadesToModule(KotlinModule kotlinModule, Map<String, KotlinFileFacadeKindMetadata> fileFacadesToMove) {
        fileFacadesToMove.forEach((fileFacadeName, referencedFileFacade) -> kotlinModule.modulePackagesAccept((__, modulePackage) -> {
            if (modulePackage.fqName.equals(ClassUtil.internalPackageName((String)fileFacadeName))) {
                modulePackage.fileFacadeNames.add(fileFacadeName);
                modulePackage.referencedFileFacades.add(referencedFileFacade);
            }
        }));
    }

    private static void addMultiFilePartsToModule(KotlinModule kotlinModule, Map<String, KotlinMultiFilePartKindMetadata> multiFilePartsToMove) {
        multiFilePartsToMove.forEach((multiFilePartName, referencedMultiFilePart) -> kotlinModule.modulePackagesAccept((__, modulePackage) -> {
            if (modulePackage.fqName.equals(ClassUtil.internalPackageName((String)multiFilePartName))) {
                modulePackage.multiFileClassParts.put(multiFilePartName, referencedMultiFilePart.xs);
                modulePackage.referencedMultiFileParts.put(multiFilePartName, referencedMultiFilePart);
            }
        }));
    }

    private static String moduleNameToFileName(String moduleName) {
        return "META-INF/*.kotlin_module".replace("*", moduleName);
    }

    private static class ModulePartCleaner
    implements KotlinModulePackageVisitor {
        private final Map<String, KotlinFileFacadeKindMetadata> fileFacadesToMove;
        private final Map<String, KotlinMultiFilePartKindMetadata> multiFilePartsToMove;

        private ModulePartCleaner(Map<String, KotlinFileFacadeKindMetadata> fileFacadesToMove, Map<String, KotlinMultiFilePartKindMetadata> multiFilePartsToMove) {
            this.fileFacadesToMove = fileFacadesToMove;
            this.multiFilePartsToMove = multiFilePartsToMove;
        }

        public void visitKotlinModulePackage(KotlinModule kotlinModule, KotlinModulePackage kotlinModulePart) {
            for (String fileFacadeName : this.fileFacadesToMove.keySet()) {
                int index = kotlinModulePart.fileFacadeNames.indexOf(fileFacadeName);
                if (index == -1) continue;
                kotlinModulePart.fileFacadeNames.remove(index);
                kotlinModulePart.referencedFileFacades.remove(index);
            }
            for (String multiFilePartName : this.multiFilePartsToMove.keySet()) {
                kotlinModulePart.multiFileClassParts.remove(multiFilePartName);
                kotlinModulePart.referencedMultiFileParts.remove(multiFilePartName);
            }
        }
    }

    private static class ToMoveCollector
    implements KotlinModulePackageVisitor {
        private final Map<String, KotlinFileFacadeKindMetadata> fileFacadesToMove;
        private final Map<String, KotlinMultiFilePartKindMetadata> multiFilePartsToMove;

        private ToMoveCollector(Map<String, KotlinFileFacadeKindMetadata> fileFacadesToMove, Map<String, KotlinMultiFilePartKindMetadata> multiFilePartsToMove) {
            this.fileFacadesToMove = fileFacadesToMove;
            this.multiFilePartsToMove = multiFilePartsToMove;
        }

        public void visitKotlinModulePackage(KotlinModule kotlinModule, KotlinModulePackage kotlinModulePart) {
            List fileFacadeNames = kotlinModulePart.fileFacadeNames;
            for (int i = 0; i < fileFacadeNames.size(); ++i) {
                String fileFacadeName = (String)fileFacadeNames.get(i);
                String fileFacadePackage = ClassUtil.internalPackageName((String)fileFacadeName);
                if (fileFacadePackage.equals(kotlinModulePart.fqName)) continue;
                this.fileFacadesToMove.put(fileFacadeName, (KotlinFileFacadeKindMetadata)kotlinModulePart.referencedFileFacades.get(i));
            }
            kotlinModulePart.referencedMultiFileParts.forEach((multiFilePartName, referencedMultiFilePart) -> {
                if (!kotlinModulePart.fqName.equals(ClassUtil.internalPackageName((String)multiFilePartName))) {
                    this.multiFilePartsToMove.put((String)multiFilePartName, (KotlinMultiFilePartKindMetadata)referencedMultiFilePart);
                }
            });
        }
    }

    private static class ModulePackageNameFixer
    implements KotlinModulePackageVisitor {
        private final List<String> packageNames;

        ModulePackageNameFixer(List<String> packageNames) {
            this.packageNames = packageNames;
        }

        public void visitKotlinModulePackage(KotlinModule kotlinModule, KotlinModulePackage kotlinModulePackage) {
            this.packageNames.add(kotlinModulePackage.fqName);
            List fileFacades = kotlinModulePackage.fileFacadeNames;
            for (int i = 0; i < fileFacades.size(); ++i) {
                KotlinFileFacadeKindMetadata referencedFileFacade = (KotlinFileFacadeKindMetadata)kotlinModulePackage.referencedFileFacades.get(i);
                fileFacades.set(i, referencedFileFacade.ownerReferencedClass.getName());
            }
            HashMap newMultiFileClassParts = new HashMap();
            kotlinModulePackage.multiFileClassParts.forEach((multiFilePartName, multiFileFacadeName) -> {
                KotlinMultiFilePartKindMetadata referencedMultiFilePart = (KotlinMultiFilePartKindMetadata)kotlinModulePackage.referencedMultiFileParts.get(multiFilePartName);
                newMultiFileClassParts.put(referencedMultiFilePart.ownerClassName, referencedMultiFilePart.facadeName);
                if (!referencedMultiFilePart.ownerClassName.equals(multiFilePartName)) {
                    kotlinModulePackage.referencedMultiFileParts.put(referencedMultiFilePart.ownerClassName, kotlinModulePackage.referencedMultiFileParts.get(multiFilePartName));
                    kotlinModulePackage.referencedMultiFileParts.remove(multiFilePartName);
                }
            });
            kotlinModulePackage.multiFileClassParts.clear();
            kotlinModulePackage.multiFileClassParts.putAll(newMultiFileClassParts);
        }
    }
}

