/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.PrintWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AppView;
import proguard.Configuration;
import proguard.classfile.visitor.ClassPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.pass.Pass;
import proguard.util.PrintWriterUtil;

public class Dumper
implements Pass {
    private static final Logger logger = LogManager.getLogger(Dumper.class);
    private final Configuration configuration;

    public Dumper(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void execute(AppView appView) throws Exception {
        logger.info("Printing classes to [{}]...", (Object)PrintWriterUtil.fileName(this.configuration.dump));
        PrintWriter pw = PrintWriterUtil.createPrintWriterOut(this.configuration.dump);
        try {
            appView.programClassPool.classesAccept((ClassVisitor)new ClassPrinter(pw));
        }
        finally {
            PrintWriterUtil.closePrintWriter(this.configuration.dump, pw);
        }
    }
}

