/*
 * Decompiled with CFR 0.152.
 */
package proguard.util.kotlin.asserter.constraint;

import java.util.List;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.util.ClassUtil;
import proguard.resources.kotlinmodule.KotlinModule;
import proguard.resources.kotlinmodule.visitor.KotlinModuleVisitor;
import proguard.util.kotlin.asserter.AssertUtil;
import proguard.util.kotlin.asserter.Reporter;
import proguard.util.kotlin.asserter.constraint.KotlinAsserterConstraint;

public class KotlinModuleIntegrity
implements KotlinAsserterConstraint,
KotlinModuleVisitor {
    private Reporter reporter;

    @Override
    public void check(Reporter reporter, ClassPool programClassPool, ClassPool libraryClassPool, Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    @Override
    public void check(Reporter reporter, KotlinModule kotlinModule) {
        this.reporter = reporter;
        kotlinModule.accept((KotlinModuleVisitor)this);
    }

    public void visitKotlinModule(KotlinModule kotlinModule) {
        AssertUtil util = new AssertUtil("Kotlin module", this.reporter, new ClassPool(), new ClassPool());
        util.reportIfNull("Module name", kotlinModule.name);
        if (!kotlinModule.fileName.startsWith("META-INF/")) {
            this.reporter.report("Module should be in the META-INF folder");
        }
        if (!kotlinModule.fileName.endsWith(".kotlin_module")) {
            this.reporter.report("Module file name extension should be .kotlin_module");
        }
        if (!kotlinModule.fileName.equals("META-INF/" + kotlinModule.name + ".kotlin_module")) {
            this.reporter.report("Module name does not match filename: \"" + kotlinModule.fileName + "\" != \"META-INF/" + kotlinModule.name + ".kotlin_module\"");
        }
        kotlinModule.modulePackagesAccept((_kotlinModule, kotlinModulePart) -> {
            util.setParentElement("Kotlin module part '" + ClassUtil.externalClassName((String)kotlinModulePart.fqName) + "'");
            util.reportIfNull("fqName", kotlinModulePart.fqName);
            if (kotlinModulePart.fileFacadeNames.size() != kotlinModulePart.referencedFileFacades.size()) {
                this.reporter.report("Mismatch between file facade names and references: " + kotlinModulePart.fileFacadeNames.size() + " != " + kotlinModulePart.referencedFileFacades.size());
            }
            if (kotlinModulePart.multiFileClassParts.size() != kotlinModulePart.referencedMultiFileParts.size()) {
                this.reporter.report("Mismatch between multi-file class parts and references: " + kotlinModulePart.multiFileClassParts.size() + " != " + kotlinModulePart.referencedMultiFileParts.size());
            }
            List referencedFileFacades = kotlinModulePart.referencedFileFacades;
            for (int i = 0; i < referencedFileFacades.size(); ++i) {
                String ffName;
                KotlinFileFacadeKindMetadata ff = (KotlinFileFacadeKindMetadata)referencedFileFacades.get(i);
                try {
                    ffName = ClassUtil.externalClassName((String)((String)kotlinModulePart.fileFacadeNames.get(i)));
                }
                catch (IndexOutOfBoundsException ignored) {
                    ffName = "unknown file facade";
                }
                util.reportIfNull("referenced file facade for '" + ffName + "'", ff);
                if (ff == null) continue;
                util.reportIfNull("referenced file facade owner reference for '" + ffName + "'", ff.ownerReferencedClass);
            }
            kotlinModulePart.referencedMultiFileParts.forEach((mfpName, mfp) -> {
                util.reportIfNull("referenced multi-file part for '" + mfpName + "'", mfp);
                if (mfp != null) {
                    util.reportIfNull("referenced multi-file part for '" + mfpName + "'", mfp.ownerReferencedClass);
                }
            });
        });
    }
}

