/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.VariableEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.VariableUsageMarker;

public class VariableShrinker
implements AttributeVisitor {
    private static final Logger logger = LogManager.getLogger(VariableShrinker.class);
    private final MemberVisitor extraVariableMemberVisitor;
    private final VariableUsageMarker variableUsageMarker = new VariableUsageMarker();
    private final VariableEditor variableEditor = new VariableEditor();

    public VariableShrinker() {
        this(null);
    }

    public VariableShrinker(MemberVisitor extraVariableMemberVisitor) {
        this.extraVariableMemberVisitor = extraVariableMemberVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if ((method.getAccessFlags() & 0x400) == 0) {
            int parameterSize = ClassUtil.internalMethodParameterSize((String)method.getDescriptor(clazz), (int)method.getAccessFlags());
            int maxLocals = codeAttribute.u2maxLocals;
            logger.debug("VariableShrinker: {}.{}{}", (Object)clazz.getName(), (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
            logger.debug("  Parameter size = {}", (Object)parameterSize);
            logger.debug("  Max locals     = {}", (Object)maxLocals);
            this.variableUsageMarker.visitCodeAttribute(clazz, method, codeAttribute);
            this.variableEditor.reset(maxLocals);
            for (int variableIndex = parameterSize; variableIndex < maxLocals; ++variableIndex) {
                if (this.variableUsageMarker.isVariableUsed(variableIndex)) continue;
                logger.debug("  Deleting local variable #{}", (Object)variableIndex);
                this.variableEditor.deleteVariable(variableIndex);
                if (this.extraVariableMemberVisitor == null) continue;
                method.accept(clazz, this.extraVariableMemberVisitor);
            }
            this.variableEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }
}

