/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.peephole.ClassMerger;

public class RetargetedClassFilter
implements ClassVisitor {
    private final ClassVisitor retargetedClassVisitor;
    private final ClassVisitor otherClassVisitor;

    public RetargetedClassFilter(ClassVisitor retargetedClassVisitor) {
        this(retargetedClassVisitor, null);
    }

    public RetargetedClassFilter(ClassVisitor retargetedClassVisitor, ClassVisitor otherClassVisitor) {
        this.retargetedClassVisitor = retargetedClassVisitor;
        this.otherClassVisitor = otherClassVisitor;
    }

    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    public void visitProgramClass(ProgramClass programClass) {
        ClassVisitor classVisitor;
        ClassVisitor classVisitor2 = classVisitor = ClassMerger.getTargetClass((Clazz)programClass) != null ? this.retargetedClassVisitor : this.otherClassVisitor;
        if (classVisitor != null) {
            classVisitor.visitProgramClass(programClass);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        if (this.otherClassVisitor != null) {
            this.otherClassVisitor.visitLibraryClass(libraryClass);
        }
    }
}

