/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.value.Value;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.ProgramMethodOptimizationInfo;

public class ParameterUsageMarker
implements MemberVisitor,
AttributeVisitor,
InstructionVisitor {
    private static final Logger logger = LogManager.getLogger(ParameterUsageMarker.class);
    private final boolean markThisParameter;
    private final boolean markAllParameters;
    private final boolean analyzeCode;
    private final PartialEvaluator partialEvaluator = new PartialEvaluator();

    public ParameterUsageMarker() {
        this(false, false);
    }

    public ParameterUsageMarker(boolean markThisParameter, boolean markAllParameters) {
        this(markThisParameter, markAllParameters, true);
    }

    public ParameterUsageMarker(boolean markThisParameter, boolean markAllParameters, boolean analyzeCode) {
        this.markThisParameter = markThisParameter;
        this.markAllParameters = markAllParameters;
        this.analyzeCode = analyzeCode;
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        int parameterSize = ClassUtil.internalMethodParameterSize((String)programMethod.getDescriptor((Clazz)programClass), (int)programMethod.getAccessFlags());
        if (parameterSize > 0) {
            int accessFlags = programMethod.getAccessFlags();
            if (this.markThisParameter && (accessFlags & 8) == 0) {
                ParameterUsageMarker.markParameterUsed((Method)programMethod, 0);
            }
            if (this.markAllParameters) {
                ParameterUsageMarker.markUsedParameters((Method)programMethod, (accessFlags & 8) != 0 ? -1L : -2L);
            }
            if ((accessFlags & 0x100) != 0) {
                ParameterUsageMarker.markUsedParameters((Method)programMethod, -1L);
            } else if ((accessFlags & 0x400) != 0) {
                ParameterUsageMarker.markParameterUsed((Method)programMethod, 0);
            } else {
                if ((accessFlags & 8) == 0 && ((accessFlags & 0x20) != 0 || programClass.mayHaveImplementations((Method)programMethod) || programMethod.getName((Clazz)programClass).equals("<init>"))) {
                    ParameterUsageMarker.markParameterUsed((Method)programMethod, 0);
                }
                if (this.analyzeCode) {
                    programMethod.attributesAccept(programClass, (AttributeVisitor)this);
                }
            }
            logger.debug("{}", new Supplier[]{() -> {
                StringBuilder debugMessage = new StringBuilder(String.format("ParameterUsageMarker: [%s.%s%s]: ", programClass.getName(), programMethod.getName((Clazz)programClass), programMethod.getDescriptor((Clazz)programClass)));
                for (int variableIndex = 0; variableIndex < parameterSize; ++variableIndex) {
                    debugMessage.append(ParameterUsageMarker.isParameterUsed((Method)programMethod, variableIndex) ? (char)'+' : (char)'-');
                }
                return debugMessage.toString();
            }});
        }
        ParameterUsageMarker.setParameterSize((Method)programMethod, parameterSize);
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (libraryClass.mayHaveImplementations((Method)libraryMethod)) {
            ParameterUsageMarker.markUsedParameters((Method)libraryMethod, -1L);
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        codeAttribute.instructionsAccept(clazz, method, (InstructionVisitor)this);
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        Value producer;
        int variableIndex;
        if (this.partialEvaluator.isTraced(offset) && variableInstruction.isLoad() && (variableIndex = variableInstruction.variableIndex) < codeAttribute.u2maxLocals && (producer = this.partialEvaluator.getVariablesBefore(offset).getProducerValue(variableIndex)) != null && producer.instructionOffsetValue().contains(variableIndex | 0x1000000)) {
            ParameterUsageMarker.markParameterUsed(method, variableIndex);
            if (variableInstruction.stackPopCount(clazz) == 2 || variableInstruction.stackPushCount(clazz) == 2) {
                ParameterUsageMarker.markParameterUsed(method, variableIndex + 1);
            }
        }
    }

    private static void setParameterSize(Method method, int parameterSize) {
        ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(method).setParameterSize(parameterSize);
    }

    public static int getParameterSize(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).getParameterSize();
    }

    public static void markParameterUsed(Method method, int variableIndex) {
        ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(method).setParameterUsed(variableIndex);
    }

    private static void markUsedParameters(Method method, long usedParameters) {
        ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(method).updateUsedParameters(usedParameters);
    }

    public static boolean hasUnusedParameters(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).hasUnusedParameters();
    }

    public static boolean isParameterUsed(Method method, int variableIndex) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).isParameterUsed(variableIndex);
    }

    public static long getUsedParameters(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).getUsedParameters();
    }
}

