/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.KeepMarker;
import proguard.optimize.info.ProgramFieldOptimizationInfo;
import proguard.optimize.info.SimpleEnumMarker;

public class SimpleEnumDescriptorSimplifier
implements ClassVisitor,
ConstantVisitor,
MemberVisitor,
AttributeVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor {
    private static final Logger logger = LogManager.getLogger(SimpleEnumDescriptorSimplifier.class);
    private static final boolean DEBUG_EXTRA = false;

    public void visitAnyClass(Clazz clazz) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        logger.debug("SimpleEnumDescriptorSimplifier: {}", (Object)programClass.getName());
        programClass.fieldsAccept((MemberVisitor)this);
        programClass.methodsAccept((MemberVisitor)this);
        programClass.constantPoolEntriesAccept((ConstantVisitor)this);
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        String name;
        Clazz referencedClass = stringConstant.referencedClass;
        if (this.isSimpleEnum(referencedClass) && ClassUtil.isInternalArrayType((String)(name = stringConstant.getString(clazz)))) {
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
            String newName = this.simplifyDescriptor(name, referencedClass);
            stringConstant.u2stringIndex = constantPoolEditor.addUtf8Constant(newName);
            stringConstant.referencedClass = null;
        }
    }

    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        String newDescriptor;
        String descriptor = invokeDynamicConstant.getType(clazz);
        if (!descriptor.equals(newDescriptor = this.simplifyDescriptor(descriptor, invokeDynamicConstant.referencedClasses))) {
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
            invokeDynamicConstant.u2nameAndTypeIndex = constantPoolEditor.addNameAndTypeConstant(invokeDynamicConstant.getName(clazz), newDescriptor);
            invokeDynamicConstant.referencedClasses = this.simplifyReferencedClasses(descriptor, invokeDynamicConstant.referencedClasses);
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        String name;
        Clazz referencedClass = classConstant.referencedClass;
        if (this.isSimpleEnum(referencedClass) && ClassUtil.isInternalArrayType((String)(name = classConstant.getName(clazz)))) {
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
            String newName = this.simplifyDescriptor(name, referencedClass);
            classConstant.u2nameIndex = constantPoolEditor.addUtf8Constant(newName);
            classConstant.referencedClass = null;
        }
    }

    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        String newDescriptor;
        String descriptor = methodTypeConstant.getType(clazz);
        if (!descriptor.equals(newDescriptor = this.simplifyDescriptor(descriptor, methodTypeConstant.referencedClasses))) {
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
            methodTypeConstant.u2descriptorIndex = constantPoolEditor.addUtf8Constant(newDescriptor);
            methodTypeConstant.referencedClasses = this.simplifyReferencedClasses(descriptor, methodTypeConstant.referencedClasses);
        }
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String newDescriptor;
        String descriptor = programField.getDescriptor((Clazz)programClass);
        if (!descriptor.equals(newDescriptor = this.simplifyDescriptor(descriptor, programField.referencedClass))) {
            String name = programField.getName((Clazz)programClass);
            String newName = name + '$' + Long.toHexString(Math.abs(descriptor.hashCode()));
            logger.debug("SimpleEnumDescriptorSimplifier: [{}.{} {}] -> [{} {}]", (Object)programClass.getName(), (Object)name, (Object)descriptor, (Object)newName, (Object)newDescriptor);
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
            programField.u2nameIndex = constantPoolEditor.addUtf8Constant(newName);
            programField.u2descriptorIndex = constantPoolEditor.addUtf8Constant(newDescriptor);
            programField.referencedClass = null;
            programField.u2accessFlags &= 0xFFFFBFFF;
            if (!KeepMarker.isKept((Field)programField)) {
                ProgramFieldOptimizationInfo.getProgramFieldOptimizationInfo((Field)programField).resetValue((Clazz)programClass, (Field)programField);
            }
            programField.attributesAccept(programClass, (AttributeVisitor)this);
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.attributesAccept(programClass, (AttributeVisitor)this);
        String descriptor = programMethod.getDescriptor((Clazz)programClass);
        String newDescriptor = this.simplifyDescriptor(descriptor, programMethod.referencedClasses);
        if (!descriptor.equals(newDescriptor)) {
            String name;
            String newName = name = programMethod.getName((Clazz)programClass);
            if (!name.equals("<init>")) {
                newName = newName + '$' + Long.toHexString(Math.abs(descriptor.hashCode()));
            }
            logger.debug("SimpleEnumDescriptorSimplifier: [{}.{}{}] -> [{}{}]", (Object)programClass.getName(), (Object)name, (Object)descriptor, (Object)newName, (Object)newDescriptor);
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
            if (!newName.equals(name)) {
                programMethod.u2nameIndex = constantPoolEditor.addUtf8Constant(newName);
            }
            programMethod.u2descriptorIndex = constantPoolEditor.addUtf8Constant(newDescriptor);
            programMethod.referencedClasses = this.simplifyReferencedClasses(descriptor, programMethod.referencedClasses);
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, (AttributeVisitor)this);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, (LocalVariableInfoVisitor)this);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, (LocalVariableTypeInfoVisitor)this);
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        String newSignature;
        String signature = signatureAttribute.getSignature(clazz);
        if (!signature.equals(newSignature = this.simplifyDescriptor(signature, signatureAttribute.referencedClasses))) {
            signatureAttribute.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newSignature);
            signatureAttribute.referencedClasses = this.simplifyReferencedClasses(signature, signatureAttribute.referencedClasses);
        }
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        String newDescriptor;
        String descriptor = localVariableInfo.getDescriptor(clazz);
        if (!descriptor.equals(newDescriptor = this.simplifyDescriptor(descriptor, localVariableInfo.referencedClass))) {
            localVariableInfo.u2descriptorIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newDescriptor);
            localVariableInfo.referencedClass = null;
        }
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        String newSignature;
        String signature;
        if (localVariableTypeInfo.referencedClasses != null && localVariableTypeInfo.referencedClasses.length > 0 && !(signature = localVariableTypeInfo.getSignature(clazz)).equals(newSignature = this.simplifyDescriptor(signature, localVariableTypeInfo.referencedClasses[0]))) {
            localVariableTypeInfo.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newSignature);
            localVariableTypeInfo.referencedClasses[0] = null;
        }
    }

    private String simplifyDescriptor(String descriptor, Clazz referencedClass) {
        return this.isSimpleEnum(referencedClass) ? descriptor.substring(0, ClassUtil.internalArrayTypeDimensionCount((String)descriptor)) + 'I' : descriptor;
    }

    private String simplifyDescriptor(String descriptor, Clazz[] referencedClasses) {
        if (referencedClasses != null) {
            Clazz referencedClass;
            String className;
            Clazz firstReferencedClass;
            String firstClassName;
            String firstFluff;
            DescriptorClassEnumeration classEnumeration;
            String type;
            logger.trace("  Before: [{}]", (Object)descriptor);
            InternalTypeEnumeration typeEnumeration = new InternalTypeEnumeration(descriptor);
            int referencedClassIndex = 0;
            StringBuffer newDescriptorBuffer = new StringBuffer(descriptor.length());
            if (typeEnumeration.hasFormalTypeParameters()) {
                type = typeEnumeration.formalTypeParameters();
                classEnumeration = new DescriptorClassEnumeration(type);
                newDescriptorBuffer.append(classEnumeration.nextFluff());
                while (classEnumeration.hasMoreClassNames()) {
                    Clazz referencedClass2;
                    String className2 = classEnumeration.nextClassName();
                    if (this.isSimpleEnum(referencedClass2 = referencedClasses[referencedClassIndex++])) {
                        className2 = "java/lang/Integer";
                    }
                    newDescriptorBuffer.append(className2);
                    newDescriptorBuffer.append(classEnumeration.nextFluff());
                }
            }
            if (typeEnumeration.isMethodSignature()) {
                newDescriptorBuffer.append('(');
            }
            while (typeEnumeration.hasMoreTypes()) {
                type = typeEnumeration.nextType();
                classEnumeration = new DescriptorClassEnumeration(type);
                firstFluff = classEnumeration.nextFluff();
                if (classEnumeration.hasMoreClassNames()) {
                    firstClassName = classEnumeration.nextClassName();
                    if (this.isSimpleEnum(firstReferencedClass = referencedClasses[referencedClassIndex++])) {
                        newDescriptorBuffer.append(type.substring(0, ClassUtil.internalArrayTypeDimensionCount((String)type)));
                        newDescriptorBuffer.append('I');
                        classEnumeration.nextFluff();
                        while (classEnumeration.hasMoreClassNames()) {
                            classEnumeration.nextClassName();
                            classEnumeration.nextFluff();
                            ++referencedClassIndex;
                        }
                        continue;
                    }
                    newDescriptorBuffer.append(firstFluff);
                    newDescriptorBuffer.append(firstClassName);
                    newDescriptorBuffer.append(classEnumeration.nextFluff());
                    while (classEnumeration.hasMoreClassNames()) {
                        className = classEnumeration.nextClassName();
                        if (this.isSimpleEnum(referencedClass = referencedClasses[referencedClassIndex++])) {
                            className = "java/lang/Integer";
                        }
                        newDescriptorBuffer.append(className);
                        newDescriptorBuffer.append(classEnumeration.nextFluff());
                    }
                    continue;
                }
                newDescriptorBuffer.append(firstFluff);
            }
            if (typeEnumeration.isMethodSignature()) {
                newDescriptorBuffer.append(')');
                type = typeEnumeration.returnType();
                classEnumeration = new DescriptorClassEnumeration(type);
                firstFluff = classEnumeration.nextFluff();
                if (classEnumeration.hasMoreClassNames()) {
                    firstClassName = classEnumeration.nextClassName();
                    if (this.isSimpleEnum(firstReferencedClass = referencedClasses[referencedClassIndex++])) {
                        newDescriptorBuffer.append(type.substring(0, ClassUtil.internalArrayTypeDimensionCount((String)type)));
                        newDescriptorBuffer.append('I');
                    } else {
                        newDescriptorBuffer.append(firstFluff);
                        newDescriptorBuffer.append(firstClassName);
                        newDescriptorBuffer.append(classEnumeration.nextFluff());
                        while (classEnumeration.hasMoreClassNames()) {
                            className = classEnumeration.nextClassName();
                            if (this.isSimpleEnum(referencedClass = referencedClasses[referencedClassIndex++])) {
                                className = "java/lang/Integer";
                            }
                            newDescriptorBuffer.append(className);
                            newDescriptorBuffer.append(classEnumeration.nextFluff());
                        }
                    }
                } else {
                    newDescriptorBuffer.append(firstFluff);
                }
            }
            descriptor = newDescriptorBuffer.toString();
            logger.trace("  After:  [{}]", (Object)descriptor);
        }
        return descriptor;
    }

    private Clazz[] simplifyReferencedClasses(String descriptor, Clazz[] referencedClasses) {
        if (referencedClasses != null) {
            Clazz referencedClass;
            Clazz firstReferencedClass;
            DescriptorClassEnumeration classEnumeration;
            String type;
            if (logger.getLevel().isLessSpecificThan(Level.TRACE)) {
                StringBuilder traceMessage = new StringBuilder("  Referenced before:");
                for (int index = 0; index < referencedClasses.length; ++index) {
                    traceMessage.append(String.format(" [%s]", referencedClasses[index] == null ? null : referencedClasses[index].getName()));
                }
                logger.trace((CharSequence)traceMessage);
            }
            InternalTypeEnumeration typeEnumeration = new InternalTypeEnumeration(descriptor);
            int referencedClassIndex = 0;
            int newReferencedClassIndex = 0;
            if (typeEnumeration.hasFormalTypeParameters()) {
                type = typeEnumeration.formalTypeParameters();
                classEnumeration = new DescriptorClassEnumeration(type);
                classEnumeration.nextFluff();
                while (classEnumeration.hasMoreClassNames()) {
                    classEnumeration.nextClassName();
                    classEnumeration.nextFluff();
                    Clazz referencedClass2 = referencedClasses[referencedClassIndex++];
                    referencedClasses[newReferencedClassIndex++] = this.isSimpleEnum(referencedClass2) ? null : referencedClass2;
                }
            }
            while (typeEnumeration.hasMoreTypes()) {
                type = typeEnumeration.nextType();
                classEnumeration = new DescriptorClassEnumeration(type);
                classEnumeration.nextFluff();
                if (!classEnumeration.hasMoreClassNames()) continue;
                classEnumeration.nextClassName();
                classEnumeration.nextFluff();
                firstReferencedClass = referencedClasses[referencedClassIndex++];
                if (this.isSimpleEnum(firstReferencedClass)) {
                    classEnumeration.nextFluff();
                    while (classEnumeration.hasMoreClassNames()) {
                        classEnumeration.nextClassName();
                        classEnumeration.nextFluff();
                        ++referencedClassIndex;
                    }
                    continue;
                }
                referencedClasses[newReferencedClassIndex++] = firstReferencedClass;
                while (classEnumeration.hasMoreClassNames()) {
                    classEnumeration.nextClassName();
                    classEnumeration.nextFluff();
                    referencedClass = referencedClasses[referencedClassIndex++];
                    referencedClasses[newReferencedClassIndex++] = this.isSimpleEnum(referencedClass) ? null : referencedClass;
                }
            }
            if (typeEnumeration.isMethodSignature()) {
                type = typeEnumeration.returnType();
                classEnumeration = new DescriptorClassEnumeration(type);
                classEnumeration.nextFluff();
                if (classEnumeration.hasMoreClassNames()) {
                    classEnumeration.nextClassName();
                    classEnumeration.nextFluff();
                    firstReferencedClass = referencedClasses[referencedClassIndex++];
                    if (!this.isSimpleEnum(firstReferencedClass)) {
                        referencedClasses[newReferencedClassIndex++] = firstReferencedClass;
                        while (classEnumeration.hasMoreClassNames()) {
                            classEnumeration.nextClassName();
                            classEnumeration.nextFluff();
                            referencedClass = referencedClasses[referencedClassIndex++];
                            referencedClasses[newReferencedClassIndex++] = this.isSimpleEnum(referencedClass) ? null : referencedClass;
                        }
                    }
                }
            }
            if (newReferencedClassIndex == 0) {
                referencedClasses = null;
            } else if (newReferencedClassIndex < referencedClassIndex) {
                Clazz[] newReferencedClasses = new Clazz[newReferencedClassIndex];
                System.arraycopy(referencedClasses, 0, newReferencedClasses, 0, newReferencedClassIndex);
                referencedClasses = newReferencedClasses;
                if (logger.getLevel().isLessSpecificThan(Level.TRACE)) {
                    StringBuilder traceMessage = new StringBuilder("  Referenced after: ");
                    for (int index = 0; index < referencedClasses.length; ++index) {
                        traceMessage.append(String.format(" [%s]", referencedClasses[index] == null ? null : referencedClasses[index].getName()));
                    }
                    logger.trace((CharSequence)traceMessage);
                }
            }
        }
        return referencedClasses;
    }

    private boolean isSimpleEnum(Clazz clazz) {
        return clazz != null && SimpleEnumMarker.isSimpleEnum(clazz);
    }
}

