/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.List;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MappingProcessor;
import proguard.obfuscate.MemberObfuscator;
import proguard.util.ListUtil;

public class MappingKeeper
implements MappingProcessor {
    private final ClassPool classPool;
    private final WarningPrinter warningPrinter;
    private Clazz clazz;

    public MappingKeeper(ClassPool classPool, WarningPrinter warningPrinter) {
        this.classPool = classPool;
        this.warningPrinter = warningPrinter;
    }

    @Override
    public boolean processClassMapping(String className, String newClassName) {
        String name = ClassUtil.internalClassName((String)className);
        this.clazz = this.classPool.getClass(name);
        if (this.clazz != null) {
            String currentNewName;
            String newName = ClassUtil.internalClassName((String)newClassName);
            if (this.warningPrinter != null && (currentNewName = ClassObfuscator.newClassName(this.clazz)) != null && !currentNewName.equals(newName)) {
                this.warningPrinter.print(name, currentNewName, "Warning: " + className + " is not being kept as '" + ClassUtil.externalClassName((String)currentNewName) + "', but remapped to '" + newClassName + "'");
            }
            ClassObfuscator.setNewClassName(this.clazz, newName);
            return true;
        }
        return false;
    }

    @Override
    public void processFieldMapping(String className, String fieldType, String fieldName, String newClassName, String newFieldName) {
        String descriptor;
        String name;
        Field field;
        if (this.clazz != null && className.equals(newClassName) && (field = this.clazz.findField(name = fieldName, descriptor = ClassUtil.internalType((String)fieldType))) != null) {
            String currentNewName;
            if (this.warningPrinter != null && (currentNewName = MemberObfuscator.newMemberName((Member)field)) != null && !currentNewName.equals(newFieldName)) {
                this.warningPrinter.print(ClassUtil.internalClassName((String)className), "Warning: " + className + ": field '" + fieldType + " " + fieldName + "' is not being kept as '" + currentNewName + "', but remapped to '" + newFieldName + "'");
            }
            MemberObfuscator.setFixedNewMemberName((Member)field, newFieldName);
        }
    }

    @Override
    public void processMethodMapping(String className, int firstLineNumber, int lastLineNumber, String methodReturnType, String methodName, String methodArguments, String newClassName, int newFirstLineNumber, int newLastLineNumber, String newMethodName) {
        String descriptor;
        Method method;
        if (this.clazz != null && className.equals(newClassName) && (method = this.clazz.findMethod(methodName, descriptor = ClassUtil.internalMethodDescriptor((String)methodReturnType, (List)ListUtil.commaSeparatedList((String)methodArguments)))) != null) {
            String currentNewName;
            if (this.warningPrinter != null && (currentNewName = MemberObfuscator.newMemberName((Member)method)) != null && !currentNewName.equals(newMethodName)) {
                this.warningPrinter.print(ClassUtil.internalClassName((String)className), "Warning: " + className + ": method '" + methodReturnType + " " + methodName + '(' + methodArguments + ')' + "' is not being kept as '" + currentNewName + "', but remapped to '" + newMethodName + "'");
            }
            MemberObfuscator.setFixedNewMemberName((Member)method, newMethodName);
        }
    }
}

