/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

final class SubclassedClassFilter
implements ClassVisitor {
    private final ClassVisitor classVisitor;

    public SubclassedClassFilter(ClassVisitor classVisitor) {
        this.classVisitor = classVisitor;
    }

    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (programClass.subClassCount > 0) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        if (libraryClass.subClassCount > 0) {
            this.classVisitor.visitLibraryClass(libraryClass);
        }
    }
}

