/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.io.PrintWriter;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.ShortestUsageMark;
import proguard.shrink.ShortestUsageMarker;
import proguard.util.Processable;

public class ShortestUsagePrinter
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    private final ShortestUsageMarker shortestUsageMarker;
    private final boolean verbose;
    private final PrintWriter pw;

    public ShortestUsagePrinter(ShortestUsageMarker shortestUsageMarker, boolean verbose, PrintWriter printWriter) {
        this.shortestUsageMarker = shortestUsageMarker;
        this.verbose = verbose;
        this.pw = printWriter;
    }

    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.pw.println(ClassUtil.externalClassName((String)programClass.getName()));
        this.printReason((Processable)programClass);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        this.pw.println(ClassUtil.externalClassName((String)libraryClass.getName()));
        this.pw.println("  is a library class.\n");
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String name = programField.getName((Clazz)programClass);
        String type = programField.getDescriptor((Clazz)programClass);
        this.pw.println(ClassUtil.externalClassName((String)programClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullFieldDescription((int)0, (String)name, (String)type) : "." + name));
        this.printReason((Processable)programField);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String name = programMethod.getName((Clazz)programClass);
        String type = programMethod.getDescriptor((Clazz)programClass);
        this.pw.print(ClassUtil.externalClassName((String)programClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullMethodDescription((String)programClass.getName(), (int)0, (String)name, (String)type) : "." + name));
        programMethod.attributesAccept(programClass, (AttributeVisitor)this);
        this.pw.println();
        this.printReason((Processable)programMethod);
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        String name = libraryField.getName((Clazz)libraryClass);
        String type = libraryField.getDescriptor((Clazz)libraryClass);
        this.pw.println(ClassUtil.externalClassName((String)libraryClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullFieldDescription((int)0, (String)name, (String)type) : "." + name));
        this.pw.println("  is a library field.\n");
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        String name = libraryMethod.getName((Clazz)libraryClass);
        String type = libraryMethod.getDescriptor((Clazz)libraryClass);
        this.pw.println(ClassUtil.externalClassName((String)libraryClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullMethodDescription((String)libraryClass.getName(), (int)0, (String)name, (String)type) : "." + name));
        this.pw.println("  is a library method.\n");
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, (AttributeVisitor)this);
    }

    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        this.pw.print(" (" + lineNumberTableAttribute.getLowestLineNumber() + ":" + lineNumberTableAttribute.getHighestLineNumber() + ")");
    }

    private void printReason(Processable processable) {
        if (this.shortestUsageMarker.isUsed(processable)) {
            ShortestUsageMark shortestUsageMark = this.shortestUsageMarker.getShortestUsageMark(processable);
            this.pw.print("  " + shortestUsageMark.getReason());
            shortestUsageMark.acceptClassVisitor(this);
            shortestUsageMark.acceptMemberVisitor(this);
        } else {
            this.pw.println("  is not being kept.\n");
        }
    }
}

