/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentation;
import graphql.execution.preparsed.NoOpPreparsedDocumentProvider;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.GraphQLSchema;
import graphql.servlet.DefaultExecutionStrategyProvider;
import graphql.servlet.ExecutionStrategyProvider;
import graphql.servlet.GraphQLBatchedInvocationInput;
import graphql.servlet.GraphQLContext;
import graphql.servlet.GraphQLInvocationInput;
import graphql.servlet.GraphQLSingleInvocationInput;
import graphql.servlet.internal.ExecutionResultHandler;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.security.auth.Subject;

public class GraphQLQueryInvoker {
    private final Supplier<ExecutionStrategyProvider> getExecutionStrategyProvider;
    private final Supplier<Instrumentation> getInstrumentation;
    private final Supplier<PreparsedDocumentProvider> getPreparsedDocumentProvider;

    protected GraphQLQueryInvoker(Supplier<ExecutionStrategyProvider> getExecutionStrategyProvider, Supplier<Instrumentation> getInstrumentation, Supplier<PreparsedDocumentProvider> getPreparsedDocumentProvider) {
        this.getExecutionStrategyProvider = getExecutionStrategyProvider;
        this.getInstrumentation = getInstrumentation;
        this.getPreparsedDocumentProvider = getPreparsedDocumentProvider;
    }

    public ExecutionResult query(GraphQLSingleInvocationInput singleInvocationInput) {
        return this.query(singleInvocationInput, singleInvocationInput.getExecutionInput());
    }

    public void query(GraphQLBatchedInvocationInput batchedInvocationInput, ExecutionResultHandler executionResultHandler) {
        Iterator<ExecutionInput> executionInputIterator = batchedInvocationInput.getExecutionInputs().iterator();
        while (executionInputIterator.hasNext()) {
            ExecutionResult result = this.query((GraphQLInvocationInput)batchedInvocationInput, executionInputIterator.next());
            executionResultHandler.accept(result, executionInputIterator.hasNext());
        }
    }

    private GraphQL newGraphQL(GraphQLSchema schema, Object context) {
        ExecutionStrategyProvider executionStrategyProvider = this.getExecutionStrategyProvider.get();
        return GraphQL.newGraphQL((GraphQLSchema)schema).queryExecutionStrategy(executionStrategyProvider.getQueryExecutionStrategy()).mutationExecutionStrategy(executionStrategyProvider.getMutationExecutionStrategy()).subscriptionExecutionStrategy(executionStrategyProvider.getSubscriptionExecutionStrategy()).instrumentation(this.getInstrumentation(context)).preparsedDocumentProvider(this.getPreparsedDocumentProvider.get()).build();
    }

    protected Instrumentation getInstrumentation(Object context) {
        if (context instanceof GraphQLContext) {
            return ((GraphQLContext)context).getDataLoaderRegistry().map(registry -> {
                ArrayList<Object> instrumentations = new ArrayList<Object>();
                instrumentations.add(this.getInstrumentation.get());
                instrumentations.add(new DataLoaderDispatcherInstrumentation(registry));
                return new ChainedInstrumentation(instrumentations);
            }).map(Instrumentation.class::cast).orElse(this.getInstrumentation.get());
        }
        return this.getInstrumentation.get();
    }

    private ExecutionResult query(GraphQLInvocationInput invocationInput, ExecutionInput executionInput) {
        if (Subject.getSubject(AccessController.getContext()) == null && invocationInput.getSubject().isPresent()) {
            return Subject.doAs(invocationInput.getSubject().get(), () -> {
                try {
                    return this.query(invocationInput.getSchema(), executionInput);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return this.query(invocationInput.getSchema(), executionInput);
    }

    private ExecutionResult query(GraphQLSchema schema, ExecutionInput executionInput) {
        return this.newGraphQL(schema, executionInput.getContext()).execute(executionInput);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Supplier<ExecutionStrategyProvider> getExecutionStrategyProvider = DefaultExecutionStrategyProvider::new;
        private Supplier<Instrumentation> getInstrumentation = () -> SimpleInstrumentation.INSTANCE;
        private Supplier<PreparsedDocumentProvider> getPreparsedDocumentProvider = () -> NoOpPreparsedDocumentProvider.INSTANCE;

        public Builder withExecutionStrategyProvider(ExecutionStrategyProvider provider) {
            return this.withExecutionStrategyProvider(() -> provider);
        }

        public Builder withExecutionStrategyProvider(Supplier<ExecutionStrategyProvider> supplier) {
            this.getExecutionStrategyProvider = supplier;
            return this;
        }

        public Builder withInstrumentation(Instrumentation instrumentation) {
            return this.withInstrumentation(() -> instrumentation);
        }

        public Builder withInstrumentation(Supplier<Instrumentation> supplier) {
            this.getInstrumentation = supplier;
            return this;
        }

        public Builder withPreparsedDocumentProvider(PreparsedDocumentProvider provider) {
            return this.withPreparsedDocumentProvider(() -> provider);
        }

        public Builder withPreparsedDocumentProvider(Supplier<PreparsedDocumentProvider> supplier) {
            this.getPreparsedDocumentProvider = supplier;
            return this;
        }

        public GraphQLQueryInvoker build() {
            return new GraphQLQueryInvoker(this.getExecutionStrategyProvider, this.getInstrumentation, this.getPreparsedDocumentProvider);
        }
    }
}

