/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.editor.playground;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.kickstart.autoconfigure.editor.playground.properties.PlaygroundProperties;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.text.StringSubstitutor;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;

@Controller
public class PlaygroundController {
    private static final String CDN_ROOT = "https://cdn.jsdelivr.net/npm/graphql-playground-react";
    private static final String CSS_PATH = "static/css/index.css";
    private static final String FAVICON_PATH = "favicon.png";
    private static final String SCRIPT_PATH = "static/js/middleware.js";
    private static final String LOGO_PATH = "logo.png";
    private static final String CSS_URL_ATTRIBUTE_NAME = "cssUrl";
    private static final String FAVICON_URL_ATTRIBUTE_NAME = "faviconUrl";
    private static final String SCRIPT_URL_ATTRIBUTE_NAME = "scriptUrl";
    private static final String LOGO_URL_ATTRIBUTE_NAME = "logoUrl";
    private static final String CSRF = "_csrf";
    private final PlaygroundProperties properties;
    private final ObjectMapper objectMapper;

    @GetMapping(value={"${graphql.playground.mapping:/playground}"})
    public ResponseEntity<String> playground(@RequestAttribute(value="_csrf", required=false) Object csrf) throws IOException {
        String template = StreamUtils.copyToString((InputStream)new ClassPathResource("templates/playground.html").getInputStream(), (Charset)Charset.defaultCharset());
        HashMap<String, String> replacements = new HashMap<String, String>();
        if (this.properties.getCdn().isEnabled()) {
            this.addCdnUrls(replacements);
        } else {
            this.addLocalAssetUrls(replacements);
        }
        replacements.put("pageTitle", this.properties.getPageTitle());
        replacements.put("properties", this.objectMapper.writeValueAsString((Object)this.properties));
        if (Objects.nonNull(csrf)) {
            replacements.put(CSRF, this.objectMapper.writeValueAsString(csrf));
        } else {
            replacements.put(CSRF, "null");
        }
        return ResponseEntity.ok().contentType(MediaType.valueOf((String)"text/html; charset=UTF-8")).body((Object)StringSubstitutor.replace((Object)template, replacements));
    }

    private String getCdnUrl(String assetPath) {
        return String.format("%s@%s/build/%s", CDN_ROOT, this.properties.getCdn().getVersion(), assetPath);
    }

    private String getLocalUrl(String assetPath) {
        return Paths.get(this.properties.getStaticPath().getBase(), assetPath).toString().replace('\\', '/');
    }

    private void addCdnUrls(Map<String, String> replacements) {
        replacements.put(CSS_URL_ATTRIBUTE_NAME, this.getCdnUrl(CSS_PATH));
        replacements.put(FAVICON_URL_ATTRIBUTE_NAME, this.getCdnUrl(FAVICON_PATH));
        replacements.put(SCRIPT_URL_ATTRIBUTE_NAME, this.getCdnUrl(SCRIPT_PATH));
        replacements.put(LOGO_URL_ATTRIBUTE_NAME, this.getCdnUrl(LOGO_PATH));
    }

    private void addLocalAssetUrls(Map<String, String> replacements) {
        replacements.put(CSS_URL_ATTRIBUTE_NAME, this.getLocalUrl(CSS_PATH));
        replacements.put(FAVICON_URL_ATTRIBUTE_NAME, this.getLocalUrl(FAVICON_PATH));
        replacements.put(SCRIPT_URL_ATTRIBUTE_NAME, this.getLocalUrl(SCRIPT_PATH));
        replacements.put(LOGO_URL_ATTRIBUTE_NAME, this.getLocalUrl(LOGO_PATH));
    }

    @Generated
    public PlaygroundController(PlaygroundProperties properties, ObjectMapper objectMapper) {
        this.properties = properties;
        this.objectMapper = objectMapper;
    }
}

