/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring.webflux;

import graphql.kickstart.execution.subscriptions.SubscriptionSession;
import graphql.kickstart.spring.webflux.ReactiveSubscriptionsProtocolFactory;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class ReactiveWebSocketSubscriptionsHandler
implements WebSocketHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactiveWebSocketSubscriptionsHandler.class);
    private final ReactiveSubscriptionsProtocolFactory subscriptionProtocolFactory;

    public List<String> getSubProtocols() {
        return Collections.singletonList("graphql-ws");
    }

    public Mono<Void> handle(WebSocketSession webSocketSession) {
        SubscriptionSession subscriptionSession = this.subscriptionProtocolFactory.createSession(webSocketSession);
        Consumer<String> consumer = this.subscriptionProtocolFactory.createConsumer(subscriptionSession);
        Mono input = webSocketSession.receive().map(WebSocketMessage::getPayloadAsText).doOnNext(consumer).doFinally(type -> subscriptionSession.close(null)).then();
        Mono sender = webSocketSession.send((Publisher)Flux.from((Publisher)subscriptionSession.getPublisher()).map(arg_0 -> ((WebSocketSession)webSocketSession).textMessage(arg_0)));
        return Mono.zip((Mono)input, (Mono)sender).then();
    }

    @Generated
    public ReactiveWebSocketSubscriptionsHandler(ReactiveSubscriptionsProtocolFactory subscriptionProtocolFactory) {
        this.subscriptionProtocolFactory = subscriptionProtocolFactory;
    }
}

