/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.execution.preparsed.NoOpPreparsedDocumentProvider;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.kickstart.execution.GraphQLRootObjectBuilder;
import graphql.kickstart.execution.config.DefaultExecutionStrategyProvider;
import graphql.kickstart.execution.config.ExecutionStrategyProvider;
import graphql.kickstart.execution.config.InstrumentationProvider;
import graphql.kickstart.execution.error.DefaultGraphQLErrorHandler;
import graphql.kickstart.execution.error.GraphQLErrorHandler;
import graphql.kickstart.execution.instrumentation.NoOpInstrumentationProvider;
import graphql.kickstart.servlet.AbstractGraphQLHttpServlet;
import graphql.kickstart.servlet.GraphQLConfiguration;
import graphql.kickstart.servlet.OsgiGraphQLHttpServletConfiguration;
import graphql.kickstart.servlet.OsgiSchemaBuilder;
import graphql.kickstart.servlet.context.DefaultGraphQLServletContextBuilder;
import graphql.kickstart.servlet.context.GraphQLServletContextBuilder;
import graphql.kickstart.servlet.core.DefaultGraphQLRootObjectBuilder;
import graphql.kickstart.servlet.core.GraphQLServletListener;
import graphql.kickstart.servlet.core.GraphQLServletRootObjectBuilder;
import graphql.kickstart.servlet.osgi.GraphQLCodeRegistryProvider;
import graphql.kickstart.servlet.osgi.GraphQLMutationProvider;
import graphql.kickstart.servlet.osgi.GraphQLProvider;
import graphql.kickstart.servlet.osgi.GraphQLQueryProvider;
import graphql.kickstart.servlet.osgi.GraphQLSubscriptionProvider;
import graphql.kickstart.servlet.osgi.GraphQLTypesProvider;
import graphql.schema.GraphQLCodeRegistry;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServlet;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;

@Component(service={HttpServlet.class, Servlet.class}, property={"service.description=GraphQL HTTP Servlet"})
@Designate(ocd=OsgiGraphQLHttpServletConfiguration.class, factory=true)
public class OsgiGraphQLHttpServlet
extends AbstractGraphQLHttpServlet {
    private final OsgiSchemaBuilder schemaBuilder = new OsgiSchemaBuilder();

    public OsgiGraphQLHttpServlet() {
        this.schemaBuilder.updateSchema();
    }

    @Activate
    public void activate(Config config) {
        this.schemaBuilder.activate(config.schema_update_delay());
    }

    @Deactivate
    public void deactivate() {
        this.schemaBuilder.deactivate();
    }

    @Override
    protected GraphQLConfiguration getConfiguration() {
        return this.schemaBuilder.buildConfiguration();
    }

    protected void updateSchema() {
        this.schemaBuilder.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindProvider(GraphQLProvider provider) {
        if (provider instanceof GraphQLQueryProvider) {
            this.schemaBuilder.add((GraphQLQueryProvider)provider);
        }
        if (provider instanceof GraphQLMutationProvider) {
            this.schemaBuilder.add((GraphQLMutationProvider)provider);
        }
        if (provider instanceof GraphQLSubscriptionProvider) {
            this.schemaBuilder.add((GraphQLSubscriptionProvider)provider);
        }
        if (provider instanceof GraphQLTypesProvider) {
            this.schemaBuilder.add((GraphQLTypesProvider)provider);
        }
        if (provider instanceof GraphQLCodeRegistryProvider) {
            this.schemaBuilder.setCodeRegistryProvider((GraphQLCodeRegistryProvider)provider);
        }
        this.updateSchema();
    }

    public void unbindProvider(GraphQLProvider provider) {
        if (provider instanceof GraphQLQueryProvider) {
            this.schemaBuilder.remove((GraphQLQueryProvider)provider);
        }
        if (provider instanceof GraphQLMutationProvider) {
            this.schemaBuilder.remove((GraphQLMutationProvider)provider);
        }
        if (provider instanceof GraphQLSubscriptionProvider) {
            this.schemaBuilder.remove((GraphQLSubscriptionProvider)provider);
        }
        if (provider instanceof GraphQLTypesProvider) {
            this.schemaBuilder.remove((GraphQLTypesProvider)provider);
        }
        if (provider instanceof GraphQLCodeRegistryProvider) {
            this.schemaBuilder.setCodeRegistryProvider(() -> GraphQLCodeRegistry.newCodeRegistry().build());
        }
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindQueryProvider(GraphQLQueryProvider queryProvider) {
        this.schemaBuilder.add(queryProvider);
        this.updateSchema();
    }

    public void unbindQueryProvider(GraphQLQueryProvider queryProvider) {
        this.schemaBuilder.remove(queryProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindMutationProvider(GraphQLMutationProvider mutationProvider) {
        this.schemaBuilder.add(mutationProvider);
        this.updateSchema();
    }

    public void unbindMutationProvider(GraphQLMutationProvider mutationProvider) {
        this.schemaBuilder.remove(mutationProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindSubscriptionProvider(GraphQLSubscriptionProvider subscriptionProvider) {
        this.schemaBuilder.add(subscriptionProvider);
        this.updateSchema();
    }

    public void unbindSubscriptionProvider(GraphQLSubscriptionProvider subscriptionProvider) {
        this.schemaBuilder.remove(subscriptionProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindTypesProvider(GraphQLTypesProvider typesProvider) {
        this.schemaBuilder.add(typesProvider);
        this.updateSchema();
    }

    public void unbindTypesProvider(GraphQLTypesProvider typesProvider) {
        this.schemaBuilder.remove(typesProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindServletListener(GraphQLServletListener listener) {
        this.schemaBuilder.add(listener);
    }

    public void unbindServletListener(GraphQLServletListener listener) {
        this.schemaBuilder.remove(listener);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setContextBuilder(GraphQLServletContextBuilder contextBuilder) {
        this.schemaBuilder.setContextBuilder(contextBuilder);
    }

    public void unsetContextBuilder(GraphQLServletContextBuilder contextBuilder) {
        this.schemaBuilder.setContextBuilder(new DefaultGraphQLServletContextBuilder());
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setRootObjectBuilder(GraphQLServletRootObjectBuilder rootObjectBuilder) {
        this.schemaBuilder.setRootObjectBuilder(rootObjectBuilder);
    }

    public void unsetRootObjectBuilder(GraphQLRootObjectBuilder rootObjectBuilder) {
        this.schemaBuilder.setRootObjectBuilder(new DefaultGraphQLRootObjectBuilder());
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setExecutionStrategyProvider(ExecutionStrategyProvider provider) {
        this.schemaBuilder.setExecutionStrategyProvider(provider);
    }

    public void unsetExecutionStrategyProvider(ExecutionStrategyProvider provider) {
        this.schemaBuilder.setExecutionStrategyProvider((ExecutionStrategyProvider)new DefaultExecutionStrategyProvider());
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setInstrumentationProvider(InstrumentationProvider provider) {
        this.schemaBuilder.setInstrumentationProvider(provider);
    }

    public void unsetInstrumentationProvider(InstrumentationProvider provider) {
        this.schemaBuilder.setInstrumentationProvider((InstrumentationProvider)new NoOpInstrumentationProvider());
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setErrorHandler(GraphQLErrorHandler errorHandler) {
        this.schemaBuilder.setErrorHandler(errorHandler);
    }

    public void unsetErrorHandler(GraphQLErrorHandler errorHandler) {
        this.schemaBuilder.setErrorHandler((GraphQLErrorHandler)new DefaultGraphQLErrorHandler());
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setPreparsedDocumentProvider(PreparsedDocumentProvider preparsedDocumentProvider) {
        this.schemaBuilder.setPreparsedDocumentProvider(preparsedDocumentProvider);
    }

    public void unsetPreparsedDocumentProvider(PreparsedDocumentProvider preparsedDocumentProvider) {
        this.schemaBuilder.setPreparsedDocumentProvider((PreparsedDocumentProvider)NoOpPreparsedDocumentProvider.INSTANCE);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void bindCodeRegistryProvider(GraphQLCodeRegistryProvider graphQLCodeRegistryProvider) {
        this.schemaBuilder.setCodeRegistryProvider(graphQLCodeRegistryProvider);
        this.updateSchema();
    }

    public void unbindCodeRegistryProvider(GraphQLCodeRegistryProvider graphQLCodeRegistryProvider) {
        this.schemaBuilder.setCodeRegistryProvider(() -> GraphQLCodeRegistry.newCodeRegistry().build());
        this.updateSchema();
    }

    static @interface Config {
        public int schema_update_delay() default 0;
    }
}

