/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet.cache;

import java.io.Serializable;
import java.util.Objects;

public class CachedResponse
implements Serializable {
    private static final long serialVersionUID = 5894555791705575139L;
    private final byte[] contentBytes;
    private final boolean error;
    private final Integer errorStatusCode;
    private final String errorMessage;

    private CachedResponse(byte[] contentBytes, boolean error, Integer errorStatusCode, String errorMessage) {
        this.contentBytes = contentBytes;
        this.error = error;
        this.errorStatusCode = errorStatusCode;
        this.errorMessage = errorMessage;
    }

    public static CachedResponse ofContent(byte[] contentBytes) {
        Objects.requireNonNull(contentBytes, "contentBytes can not be null");
        return new CachedResponse(contentBytes, false, null, null);
    }

    public static CachedResponse ofError(int errorStatusCode, String errorMessage) {
        return new CachedResponse(null, true, errorStatusCode, errorMessage);
    }

    public boolean isError() {
        return this.error;
    }

    public byte[] getContentBytes() {
        return this.contentBytes;
    }

    public Integer getErrorStatusCode() {
        return this.errorStatusCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

